// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerInfo;
import com.azure.resourcemanager.sql.models.ServerTrustGroupPropertiesTrustScopesItem;
import java.io.IOException;
import java.util.List;

/**
 * A server trust group.
 */
@Fluent
public final class ServerTrustGroupInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ServerTrustGroupProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerTrustGroupInner class.
     */
    public ServerTrustGroupInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerTrustGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the groupMembers property: Group members information for the server trust group.
     * 
     * @return the groupMembers value.
     */
    public List<ServerInfo> groupMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().groupMembers();
    }

    /**
     * Set the groupMembers property: Group members information for the server trust group.
     * 
     * @param groupMembers the groupMembers value to set.
     * @return the ServerTrustGroupInner object itself.
     */
    public ServerTrustGroupInner withGroupMembers(List<ServerInfo> groupMembers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerTrustGroupProperties();
        }
        this.innerProperties().withGroupMembers(groupMembers);
        return this;
    }

    /**
     * Get the trustScopes property: Trust scope of the server trust group.
     * 
     * @return the trustScopes value.
     */
    public List<ServerTrustGroupPropertiesTrustScopesItem> trustScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().trustScopes();
    }

    /**
     * Set the trustScopes property: Trust scope of the server trust group.
     * 
     * @param trustScopes the trustScopes value to set.
     * @return the ServerTrustGroupInner object itself.
     */
    public ServerTrustGroupInner withTrustScopes(List<ServerTrustGroupPropertiesTrustScopesItem> trustScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerTrustGroupProperties();
        }
        this.innerProperties().withTrustScopes(trustScopes);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerTrustGroupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerTrustGroupInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerTrustGroupInner.
     */
    public static ServerTrustGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerTrustGroupInner deserializedServerTrustGroupInner = new ServerTrustGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerTrustGroupInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerTrustGroupInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerTrustGroupInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerTrustGroupInner.innerProperties = ServerTrustGroupProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerTrustGroupInner;
        });
    }
}
