// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SqlAgentConfigurationPropertiesState;
import java.io.IOException;

/**
 * A recoverable managed database resource.
 */
@Fluent
public final class SqlAgentConfigurationInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private SqlAgentConfigurationProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SqlAgentConfigurationInner class.
     */
    public SqlAgentConfigurationInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private SqlAgentConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the state property: The state of Sql Agent.
     * 
     * @return the state value.
     */
    public SqlAgentConfigurationPropertiesState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: The state of Sql Agent.
     * 
     * @param state the state value to set.
     * @return the SqlAgentConfigurationInner object itself.
     */
    public SqlAgentConfigurationInner withState(SqlAgentConfigurationPropertiesState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlAgentConfigurationProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlAgentConfigurationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlAgentConfigurationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlAgentConfigurationInner.
     */
    public static SqlAgentConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlAgentConfigurationInner deserializedSqlAgentConfigurationInner = new SqlAgentConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlAgentConfigurationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSqlAgentConfigurationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSqlAgentConfigurationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSqlAgentConfigurationInner.innerProperties
                        = SqlAgentConfigurationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlAgentConfigurationInner;
        });
    }
}
