// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Properties of a vulnerability assessment scan record.
 */
@Immutable
public final class VulnerabilityAssessmentScanRecordProperties
    implements JsonSerializable<VulnerabilityAssessmentScanRecordProperties> {
    /*
     * The scan ID.
     */
    private String scanId;

    /*
     * The scan trigger type.
     */
    private VulnerabilityAssessmentScanTriggerType triggerType;

    /*
     * The scan status.
     */
    private VulnerabilityAssessmentScanState state;

    /*
     * The scan start time (UTC).
     */
    private OffsetDateTime startTime;

    /*
     * The scan end time (UTC).
     */
    private OffsetDateTime endTime;

    /*
     * The scan errors.
     */
    private List<VulnerabilityAssessmentScanError> errors;

    /*
     * The scan results storage container path.
     */
    private String storageContainerPath;

    /*
     * The number of failed security checks.
     */
    private Integer numberOfFailedSecurityChecks;

    /**
     * Creates an instance of VulnerabilityAssessmentScanRecordProperties class.
     */
    public VulnerabilityAssessmentScanRecordProperties() {
    }

    /**
     * Get the scanId property: The scan ID.
     * 
     * @return the scanId value.
     */
    public String scanId() {
        return this.scanId;
    }

    /**
     * Get the triggerType property: The scan trigger type.
     * 
     * @return the triggerType value.
     */
    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.triggerType;
    }

    /**
     * Get the state property: The scan status.
     * 
     * @return the state value.
     */
    public VulnerabilityAssessmentScanState state() {
        return this.state;
    }

    /**
     * Get the startTime property: The scan start time (UTC).
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The scan end time (UTC).
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the errors property: The scan errors.
     * 
     * @return the errors value.
     */
    public List<VulnerabilityAssessmentScanError> errors() {
        return this.errors;
    }

    /**
     * Get the storageContainerPath property: The scan results storage container path.
     * 
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Get the numberOfFailedSecurityChecks property: The number of failed security checks.
     * 
     * @return the numberOfFailedSecurityChecks value.
     */
    public Integer numberOfFailedSecurityChecks() {
        return this.numberOfFailedSecurityChecks;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VulnerabilityAssessmentScanRecordProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VulnerabilityAssessmentScanRecordProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VulnerabilityAssessmentScanRecordProperties.
     */
    public static VulnerabilityAssessmentScanRecordProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VulnerabilityAssessmentScanRecordProperties deserializedVulnerabilityAssessmentScanRecordProperties
                = new VulnerabilityAssessmentScanRecordProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scanId".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.scanId = reader.getString();
                } else if ("triggerType".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.triggerType
                        = VulnerabilityAssessmentScanTriggerType.fromString(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.state
                        = VulnerabilityAssessmentScanState.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("errors".equals(fieldName)) {
                    List<VulnerabilityAssessmentScanError> errors
                        = reader.readArray(reader1 -> VulnerabilityAssessmentScanError.fromJson(reader1));
                    deserializedVulnerabilityAssessmentScanRecordProperties.errors = errors;
                } else if ("storageContainerPath".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.storageContainerPath = reader.getString();
                } else if ("numberOfFailedSecurityChecks".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordProperties.numberOfFailedSecurityChecks
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVulnerabilityAssessmentScanRecordProperties;
        });
    }
}
