// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DistributedAvailabilityGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of distributed availability groups in instance.
 */
@Immutable
public final class DistributedAvailabilityGroupsListResult
    implements JsonSerializable<DistributedAvailabilityGroupsListResult> {
    /*
     * Array of results.
     */
    private List<DistributedAvailabilityGroupInner> value;

    /*
     * Link to retrieve next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of DistributedAvailabilityGroupsListResult class.
     */
    public DistributedAvailabilityGroupsListResult() {
    }

    /**
     * Get the value property: Array of results.
     * 
     * @return the value value.
     */
    public List<DistributedAvailabilityGroupInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to retrieve next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DistributedAvailabilityGroupsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DistributedAvailabilityGroupsListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DistributedAvailabilityGroupsListResult.
     */
    public static DistributedAvailabilityGroupsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DistributedAvailabilityGroupsListResult deserializedDistributedAvailabilityGroupsListResult
                = new DistributedAvailabilityGroupsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DistributedAvailabilityGroupInner> value
                        = reader.readArray(reader1 -> DistributedAvailabilityGroupInner.fromJson(reader1));
                    deserializedDistributedAvailabilityGroupsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDistributedAvailabilityGroupsListResult;
        });
    }
}
