// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The Elastic Pool performance level capability.
 */
@Fluent
public final class ElasticPoolPerformanceLevelCapability
    implements JsonSerializable<ElasticPoolPerformanceLevelCapability> {
    /*
     * The performance level for the pool.
     */
    private PerformanceLevelCapability performanceLevel;

    /*
     * The sku.
     */
    private Sku sku;

    /*
     * List of supported license types.
     */
    private List<LicenseTypeCapability> supportedLicenseTypes;

    /*
     * The maximum number of databases supported.
     */
    private Integer maxDatabaseCount;

    /*
     * The included (free) max size for this performance level.
     */
    private MaxSizeCapability includedMaxSize;

    /*
     * The list of supported max sizes.
     */
    private List<MaxSizeRangeCapability> supportedMaxSizes;

    /*
     * The list of supported per database max sizes.
     */
    private List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes;

    /*
     * The list of supported per database max performance levels.
     */
    private List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels;

    /*
     * Whether or not zone redundancy is supported for the performance level.
     */
    private Boolean zoneRedundant;

    /*
     * List of supported maintenance configurations
     */
    private List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ElasticPoolPerformanceLevelCapability class.
     */
    public ElasticPoolPerformanceLevelCapability() {
    }

    /**
     * Get the performanceLevel property: The performance level for the pool.
     * 
     * @return the performanceLevel value.
     */
    public PerformanceLevelCapability performanceLevel() {
        return this.performanceLevel;
    }

    /**
     * Get the sku property: The sku.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Get the supportedLicenseTypes property: List of supported license types.
     * 
     * @return the supportedLicenseTypes value.
     */
    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    /**
     * Get the maxDatabaseCount property: The maximum number of databases supported.
     * 
     * @return the maxDatabaseCount value.
     */
    public Integer maxDatabaseCount() {
        return this.maxDatabaseCount;
    }

    /**
     * Get the includedMaxSize property: The included (free) max size for this performance level.
     * 
     * @return the includedMaxSize value.
     */
    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    /**
     * Get the supportedMaxSizes property: The list of supported max sizes.
     * 
     * @return the supportedMaxSizes value.
     */
    public List<MaxSizeRangeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    /**
     * Get the supportedPerDatabaseMaxSizes property: The list of supported per database max sizes.
     * 
     * @return the supportedPerDatabaseMaxSizes value.
     */
    public List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes() {
        return this.supportedPerDatabaseMaxSizes;
    }

    /**
     * Get the supportedPerDatabaseMaxPerformanceLevels property: The list of supported per database max performance
     * levels.
     * 
     * @return the supportedPerDatabaseMaxPerformanceLevels value.
     */
    public List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels() {
        return this.supportedPerDatabaseMaxPerformanceLevels;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the performance level.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the supportedMaintenanceConfigurations property: List of supported maintenance configurations.
     * 
     * @return the supportedMaintenanceConfigurations value.
     */
    public List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations() {
        return this.supportedMaintenanceConfigurations;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ElasticPoolPerformanceLevelCapability object itself.
     */
    public ElasticPoolPerformanceLevelCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (performanceLevel() != null) {
            performanceLevel().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (supportedLicenseTypes() != null) {
            supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (includedMaxSize() != null) {
            includedMaxSize().validate();
        }
        if (supportedMaxSizes() != null) {
            supportedMaxSizes().forEach(e -> e.validate());
        }
        if (supportedPerDatabaseMaxSizes() != null) {
            supportedPerDatabaseMaxSizes().forEach(e -> e.validate());
        }
        if (supportedPerDatabaseMaxPerformanceLevels() != null) {
            supportedPerDatabaseMaxPerformanceLevels().forEach(e -> e.validate());
        }
        if (supportedMaintenanceConfigurations() != null) {
            supportedMaintenanceConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElasticPoolPerformanceLevelCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElasticPoolPerformanceLevelCapability if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ElasticPoolPerformanceLevelCapability.
     */
    public static ElasticPoolPerformanceLevelCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolPerformanceLevelCapability deserializedElasticPoolPerformanceLevelCapability
                = new ElasticPoolPerformanceLevelCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("performanceLevel".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.performanceLevel
                        = PerformanceLevelCapability.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.sku = Sku.fromJson(reader);
                } else if ("supportedLicenseTypes".equals(fieldName)) {
                    List<LicenseTypeCapability> supportedLicenseTypes
                        = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    deserializedElasticPoolPerformanceLevelCapability.supportedLicenseTypes = supportedLicenseTypes;
                } else if ("maxDatabaseCount".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.maxDatabaseCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("includedMaxSize".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.includedMaxSize
                        = MaxSizeCapability.fromJson(reader);
                } else if ("supportedMaxSizes".equals(fieldName)) {
                    List<MaxSizeRangeCapability> supportedMaxSizes
                        = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    deserializedElasticPoolPerformanceLevelCapability.supportedMaxSizes = supportedMaxSizes;
                } else if ("supportedPerDatabaseMaxSizes".equals(fieldName)) {
                    List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes
                        = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    deserializedElasticPoolPerformanceLevelCapability.supportedPerDatabaseMaxSizes
                        = supportedPerDatabaseMaxSizes;
                } else if ("supportedPerDatabaseMaxPerformanceLevels".equals(fieldName)) {
                    List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels
                        = reader.readArray(
                            reader1 -> ElasticPoolPerDatabaseMaxPerformanceLevelCapability.fromJson(reader1));
                    deserializedElasticPoolPerformanceLevelCapability.supportedPerDatabaseMaxPerformanceLevels
                        = supportedPerDatabaseMaxPerformanceLevels;
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.zoneRedundant
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("supportedMaintenanceConfigurations".equals(fieldName)) {
                    List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations
                        = reader.readArray(reader1 -> MaintenanceConfigurationCapability.fromJson(reader1));
                    deserializedElasticPoolPerformanceLevelCapability.supportedMaintenanceConfigurations
                        = supportedMaintenanceConfigurations;
                } else if ("status".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedElasticPoolPerformanceLevelCapability;
        });
    }
}
