// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Scheduling properties of a job.
 */
@Fluent
public final class JobSchedule implements JsonSerializable<JobSchedule> {
    /*
     * Schedule start time.
     */
    private OffsetDateTime startTime;

    /*
     * Schedule end time.
     */
    private OffsetDateTime endTime;

    /*
     * Schedule interval type
     */
    private JobScheduleType type;

    /*
     * Whether or not the schedule is enabled.
     */
    private Boolean enabled;

    /*
     * Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
     */
    private String interval;

    /**
     * Creates an instance of JobSchedule class.
     */
    public JobSchedule() {
    }

    /**
     * Get the startTime property: Schedule start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Schedule start time.
     * 
     * @param startTime the startTime value to set.
     * @return the JobSchedule object itself.
     */
    public JobSchedule withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: Schedule end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: Schedule end time.
     * 
     * @param endTime the endTime value to set.
     * @return the JobSchedule object itself.
     */
    public JobSchedule withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the type property: Schedule interval type.
     * 
     * @return the type value.
     */
    public JobScheduleType type() {
        return this.type;
    }

    /**
     * Set the type property: Schedule interval type.
     * 
     * @param type the type value to set.
     * @return the JobSchedule object itself.
     */
    public JobSchedule withType(JobScheduleType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the enabled property: Whether or not the schedule is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether or not the schedule is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the JobSchedule object itself.
     */
    public JobSchedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the interval property: Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601
     * duration format.
     * 
     * @return the interval value.
     */
    public String interval() {
        return this.interval;
    }

    /**
     * Set the interval property: Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601
     * duration format.
     * 
     * @param interval the interval value to set.
     * @return the JobSchedule object itself.
     */
    public JobSchedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("interval", this.interval);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobSchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobSchedule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobSchedule.
     */
    public static JobSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobSchedule deserializedJobSchedule = new JobSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedJobSchedule.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedJobSchedule.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedJobSchedule.type = JobScheduleType.fromString(reader.getString());
                } else if ("enabled".equals(fieldName)) {
                    deserializedJobSchedule.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("interval".equals(fieldName)) {
                    deserializedJobSchedule.interval = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobSchedule;
        });
    }
}
