// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Maintenance window time range.
 */
@Fluent
public final class MaintenanceWindowTimeRange implements JsonSerializable<MaintenanceWindowTimeRange> {
    /*
     * Day of maintenance window.
     */
    private DayOfWeek dayOfWeek;

    /*
     * Start time minutes offset from 12am.
     */
    private String startTime;

    /*
     * Duration of maintenance window in minutes.
     */
    private String duration;

    /**
     * Creates an instance of MaintenanceWindowTimeRange class.
     */
    public MaintenanceWindowTimeRange() {
    }

    /**
     * Get the dayOfWeek property: Day of maintenance window.
     * 
     * @return the dayOfWeek value.
     */
    public DayOfWeek dayOfWeek() {
        return this.dayOfWeek;
    }

    /**
     * Set the dayOfWeek property: Day of maintenance window.
     * 
     * @param dayOfWeek the dayOfWeek value to set.
     * @return the MaintenanceWindowTimeRange object itself.
     */
    public MaintenanceWindowTimeRange withDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    /**
     * Get the startTime property: Start time minutes offset from 12am.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time minutes offset from 12am.
     * 
     * @param startTime the startTime value to set.
     * @return the MaintenanceWindowTimeRange object itself.
     */
    public MaintenanceWindowTimeRange withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the duration property: Duration of maintenance window in minutes.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of maintenance window in minutes.
     * 
     * @param duration the duration value to set.
     * @return the MaintenanceWindowTimeRange object itself.
     */
    public MaintenanceWindowTimeRange withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dayOfWeek", this.dayOfWeek == null ? null : this.dayOfWeek.toString());
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("duration", this.duration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceWindowTimeRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceWindowTimeRange if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaintenanceWindowTimeRange.
     */
    public static MaintenanceWindowTimeRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceWindowTimeRange deserializedMaintenanceWindowTimeRange = new MaintenanceWindowTimeRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dayOfWeek".equals(fieldName)) {
                    deserializedMaintenanceWindowTimeRange.dayOfWeek = DayOfWeek.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedMaintenanceWindowTimeRange.startTime = reader.getString();
                } else if ("duration".equals(fieldName)) {
                    deserializedMaintenanceWindowTimeRange.duration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceWindowTimeRange;
        });
    }
}
