// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The parameters of a managed instance operation.
 */
@Immutable
public final class ManagedInstanceOperationParametersPair
    implements JsonSerializable<ManagedInstanceOperationParametersPair> {
    /*
     * The current parameters.
     */
    private UpsertManagedServerOperationParameters currentParameters;

    /*
     * The requested parameters.
     */
    private UpsertManagedServerOperationParameters requestedParameters;

    /**
     * Creates an instance of ManagedInstanceOperationParametersPair class.
     */
    public ManagedInstanceOperationParametersPair() {
    }

    /**
     * Get the currentParameters property: The current parameters.
     * 
     * @return the currentParameters value.
     */
    public UpsertManagedServerOperationParameters currentParameters() {
        return this.currentParameters;
    }

    /**
     * Get the requestedParameters property: The requested parameters.
     * 
     * @return the requestedParameters value.
     */
    public UpsertManagedServerOperationParameters requestedParameters() {
        return this.requestedParameters;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (currentParameters() != null) {
            currentParameters().validate();
        }
        if (requestedParameters() != null) {
            requestedParameters().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceOperationParametersPair from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceOperationParametersPair if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceOperationParametersPair.
     */
    public static ManagedInstanceOperationParametersPair fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceOperationParametersPair deserializedManagedInstanceOperationParametersPair
                = new ManagedInstanceOperationParametersPair();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("currentParameters".equals(fieldName)) {
                    deserializedManagedInstanceOperationParametersPair.currentParameters
                        = UpsertManagedServerOperationParameters.fromJson(reader);
                } else if ("requestedParameters".equals(fieldName)) {
                    deserializedManagedInstanceOperationParametersPair.requestedParameters
                        = UpsertManagedServerOperationParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceOperationParametersPair;
        });
    }
}
