// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import java.io.IOException;
import java.util.List;

/**
 * A database vulnerability assessment rule baseline.
 */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private DatabaseVulnerabilityAssessmentRuleBaselineProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DatabaseVulnerabilityAssessmentRuleBaselineInner class.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private DatabaseVulnerabilityAssessmentRuleBaselineProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the baselineResults property: The rule baseline result.
     * 
     * @return the baselineResults value.
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.innerProperties() == null ? null : this.innerProperties().baselineResults();
    }

    /**
     * Set the baselineResults property: The rule baseline result.
     * 
     * @param baselineResults the baselineResults value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner
        withBaselineResults(List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentRuleBaselineProperties();
        }
        this.innerProperties().withBaselineResults(baselineResults);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseVulnerabilityAssessmentRuleBaselineInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseVulnerabilityAssessmentRuleBaselineInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseVulnerabilityAssessmentRuleBaselineInner.
     */
    public static DatabaseVulnerabilityAssessmentRuleBaselineInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentRuleBaselineInner deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner
                = new DatabaseVulnerabilityAssessmentRuleBaselineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner.innerProperties
                        = DatabaseVulnerabilityAssessmentRuleBaselineProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseVulnerabilityAssessmentRuleBaselineInner;
        });
    }
}
