// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionState;
import java.io.IOException;

/**
 * Properties of a transparent data encryption.
 */
@Fluent
public final class TransparentDataEncryptionProperties
    implements JsonSerializable<TransparentDataEncryptionProperties> {
    /*
     * Specifies the state of the transparent data encryption.
     */
    private TransparentDataEncryptionState state;

    /**
     * Creates an instance of TransparentDataEncryptionProperties class.
     */
    public TransparentDataEncryptionProperties() {
    }

    /**
     * Get the state property: Specifies the state of the transparent data encryption.
     * 
     * @return the state value.
     */
    public TransparentDataEncryptionState state() {
        return this.state;
    }

    /**
     * Set the state property: Specifies the state of the transparent data encryption.
     * 
     * @param state the state value to set.
     * @return the TransparentDataEncryptionProperties object itself.
     */
    public TransparentDataEncryptionProperties withState(TransparentDataEncryptionState state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (state() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property state in model TransparentDataEncryptionProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TransparentDataEncryptionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TransparentDataEncryptionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TransparentDataEncryptionProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TransparentDataEncryptionProperties.
     */
    public static TransparentDataEncryptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TransparentDataEncryptionProperties deserializedTransparentDataEncryptionProperties
                = new TransparentDataEncryptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedTransparentDataEncryptionProperties.state
                        = TransparentDataEncryptionState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTransparentDataEncryptionProperties;
        });
    }
}
