// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The maintenance configuration capability.
 */
@Fluent
public final class MaintenanceConfigurationCapability implements JsonSerializable<MaintenanceConfigurationCapability> {
    /*
     * Maintenance configuration name
     */
    private String name;

    /*
     * Whether or not zone redundancy is supported for the maintenance configuration.
     */
    private Boolean zoneRedundant;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of MaintenanceConfigurationCapability class.
     */
    public MaintenanceConfigurationCapability() {
    }

    /**
     * Get the name property: Maintenance configuration name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the maintenance configuration.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the MaintenanceConfigurationCapability object itself.
     */
    public MaintenanceConfigurationCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceConfigurationCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceConfigurationCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaintenanceConfigurationCapability.
     */
    public static MaintenanceConfigurationCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceConfigurationCapability deserializedMaintenanceConfigurationCapability
                = new MaintenanceConfigurationCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMaintenanceConfigurationCapability.name = reader.getString();
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedMaintenanceConfigurationCapability.zoneRedundant
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedMaintenanceConfigurationCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedMaintenanceConfigurationCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceConfigurationCapability;
        });
    }
}
