// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The managed server capability.
 */
@Fluent
public final class ManagedInstanceEditionCapability implements JsonSerializable<ManagedInstanceEditionCapability> {
    /*
     * The managed server version name.
     */
    private String name;

    /*
     * The supported families.
     */
    private List<ManagedInstanceFamilyCapability> supportedFamilies;

    /*
     * The list of supported storage capabilities for this edition
     */
    private List<StorageCapability> supportedStorageCapabilities;

    /*
     * Whether or not zone redundancy is supported for the edition.
     */
    private Boolean zoneRedundant;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ManagedInstanceEditionCapability class.
     */
    public ManagedInstanceEditionCapability() {
    }

    /**
     * Get the name property: The managed server version name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedFamilies property: The supported families.
     * 
     * @return the supportedFamilies value.
     */
    public List<ManagedInstanceFamilyCapability> supportedFamilies() {
        return this.supportedFamilies;
    }

    /**
     * Get the supportedStorageCapabilities property: The list of supported storage capabilities for this edition.
     * 
     * @return the supportedStorageCapabilities value.
     */
    public List<StorageCapability> supportedStorageCapabilities() {
        return this.supportedStorageCapabilities;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the edition.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ManagedInstanceEditionCapability object itself.
     */
    public ManagedInstanceEditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedFamilies() != null) {
            supportedFamilies().forEach(e -> e.validate());
        }
        if (supportedStorageCapabilities() != null) {
            supportedStorageCapabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceEditionCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceEditionCapability.
     */
    public static ManagedInstanceEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceEditionCapability deserializedManagedInstanceEditionCapability
                = new ManagedInstanceEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.name = reader.getString();
                } else if ("supportedFamilies".equals(fieldName)) {
                    List<ManagedInstanceFamilyCapability> supportedFamilies
                        = reader.readArray(reader1 -> ManagedInstanceFamilyCapability.fromJson(reader1));
                    deserializedManagedInstanceEditionCapability.supportedFamilies = supportedFamilies;
                } else if ("supportedStorageCapabilities".equals(fieldName)) {
                    List<StorageCapability> supportedStorageCapabilities
                        = reader.readArray(reader1 -> StorageCapability.fromJson(reader1));
                    deserializedManagedInstanceEditionCapability.supportedStorageCapabilities
                        = supportedStorageCapabilities;
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.zoneRedundant
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceEditionCapability;
        });
    }
}
