// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstancePrivateEndpointConnectionProperties;
import java.io.IOException;

/**
 * A private endpoint connection under a managed instance.
 */
@Immutable
public final class ManagedInstancePecProperty implements JsonSerializable<ManagedInstancePecProperty> {
    /*
     * Resource ID.
     */
    private String id;

    /*
     * Private endpoint connection properties
     */
    private ManagedInstancePrivateEndpointConnectionProperties properties;

    /**
     * Creates an instance of ManagedInstancePecProperty class.
     */
    public ManagedInstancePecProperty() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the properties property: Private endpoint connection properties.
     * 
     * @return the properties value.
     */
    public ManagedInstancePrivateEndpointConnectionProperties properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstancePecProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstancePecProperty if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstancePecProperty.
     */
    public static ManagedInstancePecProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstancePecProperty deserializedManagedInstancePecProperty = new ManagedInstancePecProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedInstancePecProperty.id = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedInstancePecProperty.properties
                        = ManagedInstancePrivateEndpointConnectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstancePecProperty;
        });
    }
}
