// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The managed instance's service principal configuration for a resource.
 */
@Fluent
public final class ServicePrincipal implements JsonSerializable<ServicePrincipal> {
    /*
     * The Azure Active Directory application object id.
     */
    private String principalId;

    /*
     * The Azure Active Directory application client id.
     */
    private String clientId;

    /*
     * The Azure Active Directory tenant id.
     */
    private String tenantId;

    /*
     * Service principal type.
     */
    private ServicePrincipalType type;

    /**
     * Creates an instance of ServicePrincipal class.
     */
    public ServicePrincipal() {
    }

    /**
     * Get the principalId property: The Azure Active Directory application object id.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The Azure Active Directory application client id.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Get the tenantId property: The Azure Active Directory tenant id.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: Service principal type.
     * 
     * @return the type value.
     */
    public ServicePrincipalType type() {
        return this.type;
    }

    /**
     * Set the type property: Service principal type.
     * 
     * @param type the type value to set.
     * @return the ServicePrincipal object itself.
     */
    public ServicePrincipal withType(ServicePrincipalType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServicePrincipal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServicePrincipal if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServicePrincipal.
     */
    public static ServicePrincipal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServicePrincipal deserializedServicePrincipal = new ServicePrincipal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedServicePrincipal.principalId = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedServicePrincipal.clientId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedServicePrincipal.tenantId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServicePrincipal.type = ServicePrincipalType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServicePrincipal;
        });
    }
}
