// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the sync agent linked database.
 */
public final class SyncMemberDbType extends ExpandableStringEnum<SyncMemberDbType> {
    /**
     * Static value AzureSqlDatabase for SyncMemberDbType.
     */
    public static final SyncMemberDbType AZURE_SQL_DATABASE = fromString("AzureSqlDatabase");

    /**
     * Static value SqlServerDatabase for SyncMemberDbType.
     */
    public static final SyncMemberDbType SQL_SERVER_DATABASE = fromString("SqlServerDatabase");

    /**
     * Creates a new instance of SyncMemberDbType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SyncMemberDbType() {
    }

    /**
     * Creates or finds a SyncMemberDbType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SyncMemberDbType.
     */
    public static SyncMemberDbType fromString(String name) {
        return fromString(name, SyncMemberDbType.class);
    }

    /**
     * Gets known SyncMemberDbType values.
     * 
     * @return known SyncMemberDbType values.
     */
    public static Collection<SyncMemberDbType> values() {
        return values(SyncMemberDbType.class);
    }
}
