// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.ManagedDatabaseCreateMode;
import com.azure.resourcemanager.sql.models.ManagedDatabaseStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * A managed database resource.
 */
@Fluent
public final class ManagedDatabaseInner extends Resource {
    /*
     * Resource properties.
     */
    private ManagedDatabaseProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedDatabaseInner class.
     */
    public ManagedDatabaseInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedDatabaseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedDatabaseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the collation property: Collation of the managed database.
     * 
     * @return the collation value.
     */
    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    /**
     * Set the collation property: Collation of the managed database.
     * 
     * @param collation the collation value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    /**
     * Get the status property: Status of the database.
     * 
     * @return the status value.
     */
    public ManagedDatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the creationDate property: Creation date of the database.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the earliestRestorePoint property: Earliest restore point in time for point in time restore.
     * 
     * @return the earliestRestorePoint value.
     */
    public OffsetDateTime earliestRestorePoint() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestorePoint();
    }

    /**
     * Get the restorePointInTime property: Conditional. If createMode is PointInTimeRestore, this value is required.
     * Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new
     * database.
     * 
     * @return the restorePointInTime value.
     */
    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    /**
     * Set the restorePointInTime property: Conditional. If createMode is PointInTimeRestore, this value is required.
     * Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new
     * database.
     * 
     * @param restorePointInTime the restorePointInTime value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    /**
     * Get the defaultSecondaryLocation property: Geo paired region.
     * 
     * @return the defaultSecondaryLocation value.
     */
    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    /**
     * Get the catalogCollation property: Collation of the metadata catalog.
     * 
     * @return the catalogCollation value.
     */
    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    /**
     * Set the catalogCollation property: Collation of the metadata catalog.
     * 
     * @param catalogCollation the catalogCollation value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    /**
     * Get the createMode property: Managed database create mode. PointInTimeRestore: Create a database by restoring a
     * point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must
     * be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation,
     * StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     * geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to
     * restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup
     * (longTermRetentionBackupResourceId required).
     * 
     * @return the createMode value.
     */
    public ManagedDatabaseCreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    /**
     * Set the createMode property: Managed database create mode. PointInTimeRestore: Create a database by restoring a
     * point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must
     * be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation,
     * StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     * geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to
     * restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup
     * (longTermRetentionBackupResourceId required).
     * 
     * @param createMode the createMode value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCreateMode(ManagedDatabaseCreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    /**
     * Get the storageContainerUri property: Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the uri of the storage container where backups for this restore are stored.
     * 
     * @return the storageContainerUri value.
     */
    public String storageContainerUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerUri();
    }

    /**
     * Set the storageContainerUri property: Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the uri of the storage container where backups for this restore are stored.
     * 
     * @param storageContainerUri the storageContainerUri value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withStorageContainerUri(String storageContainerUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withStorageContainerUri(storageContainerUri);
        return this;
    }

    /**
     * Get the sourceDatabaseId property: The resource identifier of the source database associated with create
     * operation of this database.
     * 
     * @return the sourceDatabaseId value.
     */
    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    /**
     * Set the sourceDatabaseId property: The resource identifier of the source database associated with create
     * operation of this database.
     * 
     * @param sourceDatabaseId the sourceDatabaseId value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    /**
     * Get the restorableDroppedDatabaseId property: The restorable dropped database resource id to restore when
     * creating this database.
     * 
     * @return the restorableDroppedDatabaseId value.
     */
    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    /**
     * Set the restorableDroppedDatabaseId property: The restorable dropped database resource id to restore when
     * creating this database.
     * 
     * @param restorableDroppedDatabaseId the restorableDroppedDatabaseId value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    /**
     * Get the storageContainerSasToken property: Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the storage container sas token.
     * 
     * @return the storageContainerSasToken value.
     */
    public String storageContainerSasToken() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerSasToken();
    }

    /**
     * Set the storageContainerSasToken property: Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the storage container sas token.
     * 
     * @param storageContainerSasToken the storageContainerSasToken value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withStorageContainerSasToken(String storageContainerSasToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withStorageContainerSasToken(storageContainerSasToken);
        return this;
    }

    /**
     * Get the failoverGroupId property: Instance Failover Group resource identifier that this managed database belongs
     * to.
     * 
     * @return the failoverGroupId value.
     */
    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    /**
     * Get the recoverableDatabaseId property: The resource identifier of the recoverable database associated with
     * create operation of this database.
     * 
     * @return the recoverableDatabaseId value.
     */
    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    /**
     * Set the recoverableDatabaseId property: The resource identifier of the recoverable database associated with
     * create operation of this database.
     * 
     * @param recoverableDatabaseId the recoverableDatabaseId value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    /**
     * Get the longTermRetentionBackupResourceId property: The name of the Long Term Retention backup to be used for
     * restore of this managed database.
     * 
     * @return the longTermRetentionBackupResourceId value.
     */
    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    /**
     * Set the longTermRetentionBackupResourceId property: The name of the Long Term Retention backup to be used for
     * restore of this managed database.
     * 
     * @param longTermRetentionBackupResourceId the longTermRetentionBackupResourceId value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    /**
     * Get the autoCompleteRestore property: Whether to auto complete restore of this managed database.
     * 
     * @return the autoCompleteRestore value.
     */
    public Boolean autoCompleteRestore() {
        return this.innerProperties() == null ? null : this.innerProperties().autoCompleteRestore();
    }

    /**
     * Set the autoCompleteRestore property: Whether to auto complete restore of this managed database.
     * 
     * @param autoCompleteRestore the autoCompleteRestore value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withAutoCompleteRestore(Boolean autoCompleteRestore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withAutoCompleteRestore(autoCompleteRestore);
        return this;
    }

    /**
     * Get the lastBackupName property: Last backup file name for restore of this managed database.
     * 
     * @return the lastBackupName value.
     */
    public String lastBackupName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastBackupName();
    }

    /**
     * Set the lastBackupName property: Last backup file name for restore of this managed database.
     * 
     * @param lastBackupName the lastBackupName value to set.
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withLastBackupName(String lastBackupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withLastBackupName(lastBackupName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedDatabaseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedDatabaseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedDatabaseInner.
     */
    public static ManagedDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedDatabaseInner deserializedManagedDatabaseInner = new ManagedDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedDatabaseInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedDatabaseInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedDatabaseInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedDatabaseInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedDatabaseInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedDatabaseInner.innerProperties = ManagedDatabaseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedDatabaseInner;
        });
    }
}
