// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the table in the database full schema.
 */
@Immutable
public final class SyncFullSchemaTable implements JsonSerializable<SyncFullSchemaTable> {
    /*
     * List of columns in the table of database full schema.
     */
    private List<SyncFullSchemaTableColumn> columns;

    /*
     * Error id of the table.
     */
    private String errorId;

    /*
     * If there is error in the table.
     */
    private Boolean hasError;

    /*
     * Name of the table.
     */
    private String name;

    /*
     * Quoted name of the table.
     */
    private String quotedName;

    /**
     * Creates an instance of SyncFullSchemaTable class.
     */
    public SyncFullSchemaTable() {
    }

    /**
     * Get the columns property: List of columns in the table of database full schema.
     * 
     * @return the columns value.
     */
    public List<SyncFullSchemaTableColumn> columns() {
        return this.columns;
    }

    /**
     * Get the errorId property: Error id of the table.
     * 
     * @return the errorId value.
     */
    public String errorId() {
        return this.errorId;
    }

    /**
     * Get the hasError property: If there is error in the table.
     * 
     * @return the hasError value.
     */
    public Boolean hasError() {
        return this.hasError;
    }

    /**
     * Get the name property: Name of the table.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the quotedName property: Quoted name of the table.
     * 
     * @return the quotedName value.
     */
    public String quotedName() {
        return this.quotedName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncFullSchemaTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncFullSchemaTable if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncFullSchemaTable.
     */
    public static SyncFullSchemaTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncFullSchemaTable deserializedSyncFullSchemaTable = new SyncFullSchemaTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("columns".equals(fieldName)) {
                    List<SyncFullSchemaTableColumn> columns
                        = reader.readArray(reader1 -> SyncFullSchemaTableColumn.fromJson(reader1));
                    deserializedSyncFullSchemaTable.columns = columns;
                } else if ("errorId".equals(fieldName)) {
                    deserializedSyncFullSchemaTable.errorId = reader.getString();
                } else if ("hasError".equals(fieldName)) {
                    deserializedSyncFullSchemaTable.hasError = reader.getNullable(JsonReader::getBoolean);
                } else if ("name".equals(fieldName)) {
                    deserializedSyncFullSchemaTable.name = reader.getString();
                } else if ("quotedName".equals(fieldName)) {
                    deserializedSyncFullSchemaTable.quotedName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncFullSchemaTable;
        });
    }
}
