/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobScheduleType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class JobSchedule
implements JsonSerializable<JobSchedule> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private JobScheduleType type;
    private Boolean enabled;
    private String interval;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public JobSchedule withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public JobSchedule withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public JobScheduleType type() {
        return this.type;
    }

    public JobSchedule withType(JobScheduleType type) {
        this.type = type;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public JobSchedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String interval() {
        return this.interval;
    }

    public JobSchedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("interval", this.interval);
        return jsonWriter.writeEndObject();
    }

    public static JobSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (JobSchedule)jsonReader.readObject(reader -> {
            JobSchedule deserializedJobSchedule = new JobSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedJobSchedule.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobSchedule.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobSchedule.type = JobScheduleType.fromString(reader.getString());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedJobSchedule.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedJobSchedule.interval = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobSchedule;
        });
    }
}

