/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.InstancePoolEditionCapability;
import com.azure.resourcemanager.sql.models.ManagedInstanceEditionCapability;
import java.io.IOException;
import java.util.List;

public final class ManagedInstanceVersionCapability
implements JsonSerializable<ManagedInstanceVersionCapability> {
    private String name;
    private List<ManagedInstanceEditionCapability> supportedEditions;
    private List<InstancePoolEditionCapability> supportedInstancePoolEditions;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ManagedInstanceEditionCapability> supportedEditions() {
        return this.supportedEditions;
    }

    public List<InstancePoolEditionCapability> supportedInstancePoolEditions() {
        return this.supportedInstancePoolEditions;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ManagedInstanceVersionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedEditions() != null) {
            this.supportedEditions().forEach(e -> e.validate());
        }
        if (this.supportedInstancePoolEditions() != null) {
            this.supportedInstancePoolEditions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceVersionCapability)jsonReader.readObject(reader -> {
            ManagedInstanceVersionCapability deserializedManagedInstanceVersionCapability = new ManagedInstanceVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedEditions".equals(fieldName)) {
                    List supportedEditions;
                    deserializedManagedInstanceVersionCapability.supportedEditions = supportedEditions = reader.readArray(reader1 -> ManagedInstanceEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedInstancePoolEditions".equals(fieldName)) {
                    List supportedInstancePoolEditions;
                    deserializedManagedInstanceVersionCapability.supportedInstancePoolEditions = supportedInstancePoolEditions = reader.readArray(reader1 -> InstancePoolEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceVersionCapability;
        });
    }
}

