// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * User activities of a data warehouse.
 */
@Immutable
public final class DataWarehouseUserActivitiesInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private DataWarehouseUserActivitiesProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DataWarehouseUserActivitiesInner class.
     */
    public DataWarehouseUserActivitiesInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private DataWarehouseUserActivitiesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the activeQueriesCount property: Count of running and suspended queries.
     * 
     * @return the activeQueriesCount value.
     */
    public Integer activeQueriesCount() {
        return this.innerProperties() == null ? null : this.innerProperties().activeQueriesCount();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataWarehouseUserActivitiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataWarehouseUserActivitiesInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataWarehouseUserActivitiesInner.
     */
    public static DataWarehouseUserActivitiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataWarehouseUserActivitiesInner deserializedDataWarehouseUserActivitiesInner
                = new DataWarehouseUserActivitiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDataWarehouseUserActivitiesInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDataWarehouseUserActivitiesInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDataWarehouseUserActivitiesInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDataWarehouseUserActivitiesInner.innerProperties
                        = DataWarehouseUserActivitiesProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataWarehouseUserActivitiesInner;
        });
    }
}
