// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of a deleted server.
 */
@Immutable
public final class DeletedServerProperties implements JsonSerializable<DeletedServerProperties> {
    /*
     * The version of the deleted server.
     */
    private String version;

    /*
     * The deletion time of the deleted server.
     */
    private OffsetDateTime deletionTime;

    /*
     * The original ID of the server before deletion.
     */
    private String originalId;

    /*
     * The fully qualified domain name of the server.
     */
    private String fullyQualifiedDomainName;

    /**
     * Creates an instance of DeletedServerProperties class.
     */
    public DeletedServerProperties() {
    }

    /**
     * Get the version property: The version of the deleted server.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the deletionTime property: The deletion time of the deleted server.
     * 
     * @return the deletionTime value.
     */
    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    /**
     * Get the originalId property: The original ID of the server before deletion.
     * 
     * @return the originalId value.
     */
    public String originalId() {
        return this.originalId;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedServerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedServerProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedServerProperties.
     */
    public static DeletedServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedServerProperties deserializedDeletedServerProperties = new DeletedServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedDeletedServerProperties.version = reader.getString();
                } else if ("deletionTime".equals(fieldName)) {
                    deserializedDeletedServerProperties.deletionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("originalId".equals(fieldName)) {
                    deserializedDeletedServerProperties.originalId = reader.getString();
                } else if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedDeletedServerProperties.fullyQualifiedDomainName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedServerProperties;
        });
    }
}
