// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.ManagedInstancePairInfo;
import com.azure.resourcemanager.sql.models.PartnerRegionInfo;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a instance failover group.
 */
@Fluent
public final class InstanceFailoverGroupProperties implements JsonSerializable<InstanceFailoverGroupProperties> {
    /*
     * Read-write endpoint of the failover group instance.
     */
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;

    /*
     * Read-only endpoint of the failover group instance.
     */
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /*
     * Local replication role of the failover group instance.
     */
    private InstanceFailoverGroupReplicationRole replicationRole;

    /*
     * Replication state of the failover group instance.
     */
    private String replicationState;

    /*
     * Partner region information for the failover group.
     */
    private List<PartnerRegionInfo> partnerRegions;

    /*
     * List of managed instance pairs in the failover group.
     */
    private List<ManagedInstancePairInfo> managedInstancePairs;

    /**
     * Creates an instance of InstanceFailoverGroupProperties class.
     */
    public InstanceFailoverGroupProperties() {
    }

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @return the readWriteEndpoint value.
     */
    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties
        withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @return the readOnlyEndpoint value.
     */
    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties
        withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get the replicationRole property: Local replication role of the failover group instance.
     * 
     * @return the replicationRole value.
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get the replicationState property: Replication state of the failover group instance.
     * 
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the partnerRegions property: Partner region information for the failover group.
     * 
     * @return the partnerRegions value.
     */
    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    /**
     * Set the partnerRegions property: Partner region information for the failover group.
     * 
     * @param partnerRegions the partnerRegions value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    /**
     * Get the managedInstancePairs property: List of managed instance pairs in the failover group.
     * 
     * @return the managedInstancePairs value.
     */
    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    /**
     * Set the managedInstancePairs property: List of managed instance pairs in the failover group.
     * 
     * @param managedInstancePairs the managedInstancePairs value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties
        withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (readWriteEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property readWriteEndpoint in model InstanceFailoverGroupProperties"));
        } else {
            readWriteEndpoint().validate();
        }
        if (readOnlyEndpoint() != null) {
            readOnlyEndpoint().validate();
        }
        if (partnerRegions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property partnerRegions in model InstanceFailoverGroupProperties"));
        } else {
            partnerRegions().forEach(e -> e.validate());
        }
        if (managedInstancePairs() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property managedInstancePairs in model InstanceFailoverGroupProperties"));
        } else {
            managedInstancePairs().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(InstanceFailoverGroupProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("readWriteEndpoint", this.readWriteEndpoint);
        jsonWriter.writeArrayField("partnerRegions", this.partnerRegions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("managedInstancePairs", this.managedInstancePairs,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("readOnlyEndpoint", this.readOnlyEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstanceFailoverGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstanceFailoverGroupProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the InstanceFailoverGroupProperties.
     */
    public static InstanceFailoverGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstanceFailoverGroupProperties deserializedInstanceFailoverGroupProperties
                = new InstanceFailoverGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("readWriteEndpoint".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.readWriteEndpoint
                        = InstanceFailoverGroupReadWriteEndpoint.fromJson(reader);
                } else if ("partnerRegions".equals(fieldName)) {
                    List<PartnerRegionInfo> partnerRegions
                        = reader.readArray(reader1 -> PartnerRegionInfo.fromJson(reader1));
                    deserializedInstanceFailoverGroupProperties.partnerRegions = partnerRegions;
                } else if ("managedInstancePairs".equals(fieldName)) {
                    List<ManagedInstancePairInfo> managedInstancePairs
                        = reader.readArray(reader1 -> ManagedInstancePairInfo.fromJson(reader1));
                    deserializedInstanceFailoverGroupProperties.managedInstancePairs = managedInstancePairs;
                } else if ("readOnlyEndpoint".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.readOnlyEndpoint
                        = InstanceFailoverGroupReadOnlyEndpoint.fromJson(reader);
                } else if ("replicationRole".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.replicationRole
                        = InstanceFailoverGroupReplicationRole.fromString(reader.getString());
                } else if ("replicationState".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.replicationState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstanceFailoverGroupProperties;
        });
    }
}
