// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import java.io.IOException;

/**
 * A server vulnerability assessment.
 */
@Fluent
public final class ServerVulnerabilityAssessmentInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ServerVulnerabilityAssessmentProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerVulnerabilityAssessmentInner class.
     */
    public ServerVulnerabilityAssessmentInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerVulnerabilityAssessmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     * 
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerPath();
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     * 
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the ServerVulnerabilityAssessmentInner object itself.
     */
    public ServerVulnerabilityAssessmentInner withStorageContainerPath(String storageContainerPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageContainerPath(storageContainerPath);
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerSasKey();
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the ServerVulnerabilityAssessmentInner object itself.
     */
    public ServerVulnerabilityAssessmentInner withStorageContainerSasKey(String storageContainerSasKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageContainerSasKey(storageContainerSasKey);
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountAccessKey();
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the ServerVulnerabilityAssessmentInner object itself.
     */
    public ServerVulnerabilityAssessmentInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     * 
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.innerProperties() == null ? null : this.innerProperties().recurringScans();
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     * 
     * @param recurringScans the recurringScans value to set.
     * @return the ServerVulnerabilityAssessmentInner object itself.
     */
    public ServerVulnerabilityAssessmentInner
        withRecurringScans(VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerVulnerabilityAssessmentProperties();
        }
        this.innerProperties().withRecurringScans(recurringScans);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerVulnerabilityAssessmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerVulnerabilityAssessmentInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerVulnerabilityAssessmentInner.
     */
    public static ServerVulnerabilityAssessmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerVulnerabilityAssessmentInner deserializedServerVulnerabilityAssessmentInner
                = new ServerVulnerabilityAssessmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentInner.innerProperties
                        = ServerVulnerabilityAssessmentProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerVulnerabilityAssessmentInner;
        });
    }
}
