// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import java.io.IOException;

/**
 * Properties of an Azure SQL Database sync agent linked database.
 */
@Immutable
public final class SyncAgentLinkedDatabaseProperties implements JsonSerializable<SyncAgentLinkedDatabaseProperties> {
    /*
     * Type of the sync agent linked database.
     */
    private SyncMemberDbType databaseType;

    /*
     * Id of the sync agent linked database.
     */
    private String databaseId;

    /*
     * Description of the sync agent linked database.
     */
    private String description;

    /*
     * Server name of the sync agent linked database.
     */
    private String serverName;

    /*
     * Database name of the sync agent linked database.
     */
    private String databaseName;

    /*
     * User name of the sync agent linked database.
     */
    private String username;

    /**
     * Creates an instance of SyncAgentLinkedDatabaseProperties class.
     */
    public SyncAgentLinkedDatabaseProperties() {
    }

    /**
     * Get the databaseType property: Type of the sync agent linked database.
     * 
     * @return the databaseType value.
     */
    public SyncMemberDbType databaseType() {
        return this.databaseType;
    }

    /**
     * Get the databaseId property: Id of the sync agent linked database.
     * 
     * @return the databaseId value.
     */
    public String databaseId() {
        return this.databaseId;
    }

    /**
     * Get the description property: Description of the sync agent linked database.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the serverName property: Server name of the sync agent linked database.
     * 
     * @return the serverName value.
     */
    public String serverName() {
        return this.serverName;
    }

    /**
     * Get the databaseName property: Database name of the sync agent linked database.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the username property: User name of the sync agent linked database.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncAgentLinkedDatabaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncAgentLinkedDatabaseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncAgentLinkedDatabaseProperties.
     */
    public static SyncAgentLinkedDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncAgentLinkedDatabaseProperties deserializedSyncAgentLinkedDatabaseProperties
                = new SyncAgentLinkedDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseType".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.databaseType
                        = SyncMemberDbType.fromString(reader.getString());
                } else if ("databaseId".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.databaseId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.description = reader.getString();
                } else if ("serverName".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.serverName = reader.getString();
                } else if ("databaseName".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.databaseName = reader.getString();
                } else if ("userName".equals(fieldName)) {
                    deserializedSyncAgentLinkedDatabaseProperties.username = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncAgentLinkedDatabaseProperties;
        });
    }
}
