// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of a virtual cluster.
 */
@Fluent
public final class VirtualClusterProperties implements JsonSerializable<VirtualClusterProperties> {
    /*
     * Subnet resource ID for the virtual cluster.
     */
    private String subnetId;

    /*
     * If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    private String family;

    /*
     * List of resources in this virtual cluster.
     */
    private List<String> childResources;

    /*
     * Specifies maintenance configuration id to apply to this virtual cluster.
     */
    private String maintenanceConfigurationId;

    /**
     * Creates an instance of VirtualClusterProperties class.
     */
    public VirtualClusterProperties() {
    }

    /**
     * Get the subnetId property: Subnet resource ID for the virtual cluster.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Get the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     * 
     * @return the family value.
     */
    public String family() {
        return this.family;
    }

    /**
     * Set the family property: If the service has different generations of hardware, for the same SKU, then that can be
     * captured here.
     * 
     * @param family the family value to set.
     * @return the VirtualClusterProperties object itself.
     */
    public VirtualClusterProperties withFamily(String family) {
        this.family = family;
        return this;
    }

    /**
     * Get the childResources property: List of resources in this virtual cluster.
     * 
     * @return the childResources value.
     */
    public List<String> childResources() {
        return this.childResources;
    }

    /**
     * Get the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     * 
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    /**
     * Set the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this virtual
     * cluster.
     * 
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the VirtualClusterProperties object itself.
     */
    public VirtualClusterProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualClusterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualClusterProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualClusterProperties.
     */
    public static VirtualClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualClusterProperties deserializedVirtualClusterProperties = new VirtualClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnetId".equals(fieldName)) {
                    deserializedVirtualClusterProperties.subnetId = reader.getString();
                } else if ("family".equals(fieldName)) {
                    deserializedVirtualClusterProperties.family = reader.getString();
                } else if ("childResources".equals(fieldName)) {
                    List<String> childResources = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualClusterProperties.childResources = childResources;
                } else if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedVirtualClusterProperties.maintenanceConfigurationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualClusterProperties;
        });
    }
}
