// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * A vulnerability assessment scan record.
 */
@Immutable
public final class VulnerabilityAssessmentScanRecordInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private VulnerabilityAssessmentScanRecordProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of VulnerabilityAssessmentScanRecordInner class.
     */
    public VulnerabilityAssessmentScanRecordInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private VulnerabilityAssessmentScanRecordProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the scanId property: The scan ID.
     * 
     * @return the scanId value.
     */
    public String scanId() {
        return this.innerProperties() == null ? null : this.innerProperties().scanId();
    }

    /**
     * Get the triggerType property: The scan trigger type.
     * 
     * @return the triggerType value.
     */
    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerType();
    }

    /**
     * Get the state property: The scan status.
     * 
     * @return the state value.
     */
    public VulnerabilityAssessmentScanState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the startTime property: The scan start time (UTC).
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: The scan end time (UTC).
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the errors property: The scan errors.
     * 
     * @return the errors value.
     */
    public List<VulnerabilityAssessmentScanError> errors() {
        return this.innerProperties() == null ? null : this.innerProperties().errors();
    }

    /**
     * Get the storageContainerPath property: The scan results storage container path.
     * 
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerPath();
    }

    /**
     * Get the numberOfFailedSecurityChecks property: The number of failed security checks.
     * 
     * @return the numberOfFailedSecurityChecks value.
     */
    public Integer numberOfFailedSecurityChecks() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfFailedSecurityChecks();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VulnerabilityAssessmentScanRecordInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VulnerabilityAssessmentScanRecordInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VulnerabilityAssessmentScanRecordInner.
     */
    public static VulnerabilityAssessmentScanRecordInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VulnerabilityAssessmentScanRecordInner deserializedVulnerabilityAssessmentScanRecordInner
                = new VulnerabilityAssessmentScanRecordInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentScanRecordInner.innerProperties
                        = VulnerabilityAssessmentScanRecordProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVulnerabilityAssessmentScanRecordInner;
        });
    }
}
