// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.LongTermRetentionBackupsClient;
import com.azure.resourcemanager.sql.fluent.models.LongTermRetentionBackupInner;
import com.azure.resourcemanager.sql.fluent.models.LongTermRetentionBackupOperationResultInner;
import com.azure.resourcemanager.sql.models.CopyLongTermRetentionBackupParameters;
import com.azure.resourcemanager.sql.models.DatabaseState;
import com.azure.resourcemanager.sql.models.LongTermRetentionBackupListResult;
import com.azure.resourcemanager.sql.models.UpdateLongTermRetentionBackupParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in LongTermRetentionBackupsClient.
 */
public final class LongTermRetentionBackupsClientImpl implements LongTermRetentionBackupsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final LongTermRetentionBackupsService service;

    /**
     * The service client containing this operation class.
     */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of LongTermRetentionBackupsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    LongTermRetentionBackupsClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(LongTermRetentionBackupsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlManagementClientLongTermRetentionBackups to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientL")
    public interface LongTermRetentionBackupsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByLocation(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByServer(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByDatabase(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupInner>> get(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> copy(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyLongTermRetentionBackupParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UpdateLongTermRetentionBackupParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocation(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServer(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabase(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") DatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> copyByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyLongTermRetentionBackupParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UpdateLongTermRetentionBackupParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByServerNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByDatabaseNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServerNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabaseNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(String locationName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByLocation(this.client.getEndpoint(), locationName, onlyLatestPerDatabase,
                    databaseState, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(String locationName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByLocation(this.client.getEndpoint(), locationName, onlyLatestPerDatabase, databaseState,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        return new PagedFlux<>(() -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(() -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedFlux<>(
            () -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(String locationName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedIterable<>(listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(String locationName,
        String longTermRetentionServerName, Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByServer(this.client.getEndpoint(), locationName,
                longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(String locationName,
        String longTermRetentionServerName, Boolean onlyLatestPerDatabase, DatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByServer(this.client.getEndpoint(), locationName, longTermRetentionServerName, onlyLatestPerDatabase,
                databaseState, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName,
        String longTermRetentionServerName, Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        return new PagedFlux<>(() -> listByServerSinglePageAsync(locationName, longTermRetentionServerName,
            onlyLatestPerDatabase, databaseState), nextLink -> listByServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName,
        String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(() -> listByServerSinglePageAsync(locationName, longTermRetentionServerName,
            onlyLatestPerDatabase, databaseState), nextLink -> listByServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName,
        String longTermRetentionServerName, Boolean onlyLatestPerDatabase, DatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(() -> listByServerSinglePageAsync(locationName, longTermRetentionServerName,
            onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByServerNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(String locationName,
        String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(
            listByServerAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(String locationName,
        String longTermRetentionServerName, Boolean onlyLatestPerDatabase, DatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(listByServerAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase,
            databaseState, context));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByDatabase(this.client.getEndpoint(), locationName,
                longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByDatabase(this.client.getEndpoint(), locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState) {
        return new PagedFlux<>(
            () -> listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(
            () -> listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState, Context context) {
        return new PagedFlux<>(
            () -> listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(listByDatabaseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState, Context context) {
        return new PagedIterable<>(listByDatabaseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getAsync(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        return getWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName,
            backupName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getWithResponse(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return getWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName,
            backupName, context).block();
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupInner get(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        return getWithResponse(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            Context.NONE).getValue();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            context);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        return this
            .beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, Context context) {
        return this
            .beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                context)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        return beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, Context context) {
        return beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName) {
        deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, Context context) {
        deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context)
            .block();
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> copyWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        CopyLongTermRetentionBackupParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.copy(this.client.getEndpoint(), locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> copyWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        CopyLongTermRetentionBackupParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.copy(this.client.getEndpoint(), locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, CopyLongTermRetentionBackupParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = copyWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, this.client.getContext());
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, CopyLongTermRetentionBackupParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = copyWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, context);
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopy(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, CopyLongTermRetentionBackupParameters parameters) {
        return this
            .beginCopyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                parameters)
            .getSyncPoller();
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopy(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, CopyLongTermRetentionBackupParameters parameters, Context context) {
        return this
            .beginCopyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                parameters, context)
            .getSyncPoller();
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupOperationResultInner> copyAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        CopyLongTermRetentionBackupParameters parameters) {
        return beginCopyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LongTermRetentionBackupOperationResultInner> copyAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        CopyLongTermRetentionBackupParameters parameters, Context context) {
        return beginCopyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner copy(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters) {
        return copyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters).block();
    }

    /**
     * Copy an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner copy(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters,
        Context context) {
        return copyAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters, context).block();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        UpdateLongTermRetentionBackupParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        UpdateLongTermRetentionBackupParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, this.client.getContext());
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, UpdateLongTermRetentionBackupParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, context);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdate(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        return this
            .beginUpdateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                parameters)
            .getSyncPoller();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdate(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
            String backupName, UpdateLongTermRetentionBackupParameters parameters, Context context) {
        return this
            .beginUpdateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                parameters, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupOperationResultInner> updateAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        UpdateLongTermRetentionBackupParameters parameters) {
        return beginUpdateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LongTermRetentionBackupOperationResultInner> updateAsync(String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
        UpdateLongTermRetentionBackupParameters parameters, Context context) {
        return beginUpdateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner update(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        return updateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters).block();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner update(String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, UpdateLongTermRetentionBackupParameters parameters,
        Context context) {
        return updateAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
            parameters, context).block();
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(
        String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroupLocation(this.client.getEndpoint(), resourceGroupName,
                locationName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(
        String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, DatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupLocation(this.client.getEndpoint(), resourceGroupName, locationName,
                onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName,
        String locationName, Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        return new PagedFlux<>(() -> listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName,
            onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName,
        String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(() -> listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName,
            onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName,
        String locationName, Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName,
            onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(String resourceGroupName,
        String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(
            listByResourceGroupLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given location.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(String resourceGroupName,
        String locationName, Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedIterable<>(listByResourceGroupLocationAsync(resourceGroupName, locationName,
            onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(
        String resourceGroupName, String locationName, String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroupServer(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(
        String resourceGroupName, String locationName, String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupServer(this.client.getEndpoint(), resourceGroupName, locationName,
                longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState) {
        return new PagedFlux<>(
            () -> listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName,
                onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(
            () -> listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName,
                onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName,
                onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(String resourceGroupName,
        String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(listByResourceGroupServerAsync(resourceGroupName, locationName,
            longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(String resourceGroupName,
        String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase,
        DatabaseState databaseState, Context context) {
        return new PagedIterable<>(listByResourceGroupServerAsync(resourceGroupName, locationName,
            longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(
        String resourceGroupName, String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroupDatabase(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase,
                databaseState, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(
        String resourceGroupName, String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, DatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupDatabase(this.client.getEndpoint(), resourceGroupName, locationName,
                longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState) {
        return new PagedFlux<>(
            () -> listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName,
                longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedFlux<>(
            () -> listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName,
                longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final DatabaseState databaseState = null;
        return new PagedIterable<>(listByResourceGroupDatabaseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists all long term retention backups for a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase, DatabaseState databaseState, Context context) {
        return new PagedIterable<>(listByResourceGroupDatabaseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(),
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getByResourceGroupAsync(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getByResourceGroupWithResponse(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, context).block();
    }

    /**
     * Gets a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupInner getByResourceGroup(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return getByResourceGroupWithResponse(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, Context.NONE).getValue();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.deleteByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(),
            this.client.getApiVersion(), context);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this
            .beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return this
            .beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, context)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String locationName,
        String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName) {
        deleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName).block();
    }

    /**
     * Deletes a long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
        String longTermRetentionDatabaseName, String backupName, Context context) {
        deleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, context).block();
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> copyByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.copyByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> copyByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.copyByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(),
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = copyByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, this.client.getContext());
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = copyByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters, context);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, context);
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters) {
        return this
            .beginCopyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, parameters)
            .getSyncPoller();
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginCopyByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName, CopyLongTermRetentionBackupParameters parameters,
            Context context) {
        return this
            .beginCopyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupOperationResultInner> copyByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters) {
        return beginCopyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LongTermRetentionBackupOperationResultInner> copyByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters, Context context) {
        return beginCopyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner copyByResourceGroup(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters) {
        return copyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters).block();
    }

    /**
     * Copy an existing long term retention backup to a different server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The parameters needed for long term retention copy request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner copyByResourceGroup(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, CopyLongTermRetentionBackupParameters parameters, Context context) {
        return copyByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context).block();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateByResourceGroupWithResponseAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(),
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateByResourceGroupAsync(String resourceGroupName, String locationName,
            String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
            UpdateLongTermRetentionBackupParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, this.client.getContext());
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateByResourceGroupAsync(String resourceGroupName, String locationName,
            String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName,
            UpdateLongTermRetentionBackupParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateByResourceGroupWithResponseAsync(resourceGroupName, locationName,
            longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters, context);
        return this.client
            .<LongTermRetentionBackupOperationResultInner, LongTermRetentionBackupOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), LongTermRetentionBackupOperationResultInner.class,
                LongTermRetentionBackupOperationResultInner.class, context);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName,
            UpdateLongTermRetentionBackupParameters parameters) {
        return this
            .beginUpdateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, parameters)
            .getSyncPoller();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<LongTermRetentionBackupOperationResultInner>, LongTermRetentionBackupOperationResultInner>
        beginUpdateByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName,
            String longTermRetentionDatabaseName, String backupName, UpdateLongTermRetentionBackupParameters parameters,
            Context context) {
        return this
            .beginUpdateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
                longTermRetentionDatabaseName, backupName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupOperationResultInner> updateByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        return beginUpdateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<LongTermRetentionBackupOperationResultInner> updateByResourceGroupAsync(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters, Context context) {
        return beginUpdateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner updateByResourceGroup(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters) {
        return updateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters).block();
    }

    /**
     * Updates an existing long term retention backup.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param parameters The requested backup resource state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a LongTermRetentionBackup operation result resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupOperationResultInner updateByResourceGroup(String resourceGroupName,
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName,
        String backupName, UpdateLongTermRetentionBackupParameters parameters, Context context) {
        return updateByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName,
            longTermRetentionDatabaseName, backupName, parameters, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByLocationNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByLocationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByServerNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByServerNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByDatabaseNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByDatabaseNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listByResourceGroupLocationNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupLocationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupServerNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupServerNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listByResourceGroupDatabaseNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>>
        listByResourceGroupDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupDatabaseNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
