// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DatabaseExtensionsProperties;
import java.io.IOException;

/**
 * An Import, Export, or PolybaseImport resource.
 */
@Fluent
public final class DatabaseExtensions extends ProxyResource {
    /*
     * Resource properties.
     */
    private DatabaseExtensionsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DatabaseExtensions class.
     */
    public DatabaseExtensions() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private DatabaseExtensionsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the operationMode property: Operation mode of the operation: Import, Export, or PolybaseImport.
     * 
     * @return the operationMode value.
     */
    public OperationMode operationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().operationMode();
    }

    /**
     * Set the operationMode property: Operation mode of the operation: Import, Export, or PolybaseImport.
     * 
     * @param operationMode the operationMode value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withOperationMode(OperationMode operationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withOperationMode(operationMode);
        return this;
    }

    /**
     * Get the storageKeyType property: Storage key type: StorageAccessKey or SharedAccessKey.
     * 
     * @return the storageKeyType value.
     */
    public StorageKeyType storageKeyType() {
        return this.innerProperties() == null ? null : this.innerProperties().storageKeyType();
    }

    /**
     * Set the storageKeyType property: Storage key type: StorageAccessKey or SharedAccessKey.
     * 
     * @param storageKeyType the storageKeyType value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withStorageKeyType(StorageKeyType storageKeyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageKeyType(storageKeyType);
        return this;
    }

    /**
     * Get the storageKey property: Storage key for the storage account.
     * 
     * @return the storageKey value.
     */
    public String storageKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageKey();
    }

    /**
     * Set the storageKey property: Storage key for the storage account.
     * 
     * @param storageKey the storageKey value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withStorageKey(String storageKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageKey(storageKey);
        return this;
    }

    /**
     * Get the storageUri property: Storage Uri for the storage account.
     * 
     * @return the storageUri value.
     */
    public String storageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUri();
    }

    /**
     * Set the storageUri property: Storage Uri for the storage account.
     * 
     * @param storageUri the storageUri value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withStorageUri(String storageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageUri(storageUri);
        return this;
    }

    /**
     * Get the administratorLogin property: Administrator login name.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: Administrator login name.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: Administrator login password.
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: Administrator login password.
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the authenticationType property: Authentication type: SQL authentication or AD password.
     * 
     * @return the authenticationType value.
     */
    public String authenticationType() {
        return this.innerProperties() == null ? null : this.innerProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: Authentication type: SQL authentication or AD password.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withAuthenticationType(String authenticationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the databaseEdition property: Database edition for the newly created database in the case of an import
     * operation.
     * 
     * @return the databaseEdition value.
     */
    public String databaseEdition() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseEdition();
    }

    /**
     * Set the databaseEdition property: Database edition for the newly created database in the case of an import
     * operation.
     * 
     * @param databaseEdition the databaseEdition value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withDatabaseEdition(String databaseEdition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withDatabaseEdition(databaseEdition);
        return this;
    }

    /**
     * Get the serviceObjectiveName property: Database service level objective for the newly created database in the
     * case of an import operation.
     * 
     * @return the serviceObjectiveName value.
     */
    public String serviceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceObjectiveName();
    }

    /**
     * Set the serviceObjectiveName property: Database service level objective for the newly created database in the
     * case of an import operation.
     * 
     * @param serviceObjectiveName the serviceObjectiveName value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withServiceObjectiveName(String serviceObjectiveName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withServiceObjectiveName(serviceObjectiveName);
        return this;
    }

    /**
     * Get the maxSizeBytes property: Database max size in bytes for the newly created database in the case of an import
     * operation.
     * 
     * @return the maxSizeBytes value.
     */
    public String maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    /**
     * Set the maxSizeBytes property: Database max size in bytes for the newly created database in the case of an import
     * operation.
     * 
     * @param maxSizeBytes the maxSizeBytes value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withMaxSizeBytes(String maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    /**
     * Get the networkIsolation property: Optional resource information to enable network isolation for request.
     * 
     * @return the networkIsolation value.
     */
    public NetworkIsolationSettings networkIsolation() {
        return this.innerProperties() == null ? null : this.innerProperties().networkIsolation();
    }

    /**
     * Set the networkIsolation property: Optional resource information to enable network isolation for request.
     * 
     * @param networkIsolation the networkIsolation value to set.
     * @return the DatabaseExtensions object itself.
     */
    public DatabaseExtensions withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withNetworkIsolation(networkIsolation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseExtensions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseExtensions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseExtensions.
     */
    public static DatabaseExtensions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseExtensions deserializedDatabaseExtensions = new DatabaseExtensions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDatabaseExtensions.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDatabaseExtensions.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDatabaseExtensions.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDatabaseExtensions.innerProperties = DatabaseExtensionsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseExtensions;
        });
    }
}
