// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and
 * 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
 */
public final class ManagedInstanceLicenseType extends ExpandableStringEnum<ManagedInstanceLicenseType> {
    /**
     * Static value LicenseIncluded for ManagedInstanceLicenseType.
     */
    public static final ManagedInstanceLicenseType LICENSE_INCLUDED = fromString("LicenseIncluded");

    /**
     * Static value BasePrice for ManagedInstanceLicenseType.
     */
    public static final ManagedInstanceLicenseType BASE_PRICE = fromString("BasePrice");

    /**
     * Creates a new instance of ManagedInstanceLicenseType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ManagedInstanceLicenseType() {
    }

    /**
     * Creates or finds a ManagedInstanceLicenseType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ManagedInstanceLicenseType.
     */
    public static ManagedInstanceLicenseType fromString(String name) {
        return fromString(name, ManagedInstanceLicenseType.class);
    }

    /**
     * Gets known ManagedInstanceLicenseType values.
     * 
     * @return known ManagedInstanceLicenseType values.
     */
    public static Collection<ManagedInstanceLicenseType> values() {
        return values(ManagedInstanceLicenseType.class);
    }
}
