// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a security event sql injection additional properties.
 */
@Immutable
public final class SecurityEventSqlInjectionAdditionalProperties
    implements JsonSerializable<SecurityEventSqlInjectionAdditionalProperties> {
    /*
     * The threat ID.
     */
    private String threatId;

    /*
     * The statement
     */
    private String statement;

    /*
     * The statement highlight offset
     */
    private Integer statementHighlightOffset;

    /*
     * The statement highlight length
     */
    private Integer statementHighlightLength;

    /*
     * The sql error code
     */
    private Integer errorCode;

    /*
     * The sql error severity
     */
    private Integer errorSeverity;

    /*
     * The sql error message
     */
    private String errorMessage;

    /**
     * Creates an instance of SecurityEventSqlInjectionAdditionalProperties class.
     */
    public SecurityEventSqlInjectionAdditionalProperties() {
    }

    /**
     * Get the threatId property: The threat ID.
     * 
     * @return the threatId value.
     */
    public String threatId() {
        return this.threatId;
    }

    /**
     * Get the statement property: The statement.
     * 
     * @return the statement value.
     */
    public String statement() {
        return this.statement;
    }

    /**
     * Get the statementHighlightOffset property: The statement highlight offset.
     * 
     * @return the statementHighlightOffset value.
     */
    public Integer statementHighlightOffset() {
        return this.statementHighlightOffset;
    }

    /**
     * Get the statementHighlightLength property: The statement highlight length.
     * 
     * @return the statementHighlightLength value.
     */
    public Integer statementHighlightLength() {
        return this.statementHighlightLength;
    }

    /**
     * Get the errorCode property: The sql error code.
     * 
     * @return the errorCode value.
     */
    public Integer errorCode() {
        return this.errorCode;
    }

    /**
     * Get the errorSeverity property: The sql error severity.
     * 
     * @return the errorSeverity value.
     */
    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    /**
     * Get the errorMessage property: The sql error message.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityEventSqlInjectionAdditionalProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityEventSqlInjectionAdditionalProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityEventSqlInjectionAdditionalProperties.
     */
    public static SecurityEventSqlInjectionAdditionalProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityEventSqlInjectionAdditionalProperties deserializedSecurityEventSqlInjectionAdditionalProperties
                = new SecurityEventSqlInjectionAdditionalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("threatId".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.threatId = reader.getString();
                } else if ("statement".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.statement = reader.getString();
                } else if ("statementHighlightOffset".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.statementHighlightOffset
                        = reader.getNullable(JsonReader::getInt);
                } else if ("statementHighlightLength".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.statementHighlightLength
                        = reader.getNullable(JsonReader::getInt);
                } else if ("errorCode".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.errorCode
                        = reader.getNullable(JsonReader::getInt);
                } else if ("errorSeverity".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.errorSeverity
                        = reader.getNullable(JsonReader::getInt);
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedSecurityEventSqlInjectionAdditionalProperties.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityEventSqlInjectionAdditionalProperties;
        });
    }
}
