// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * State of the sync agent.
 */
public final class SyncAgentState extends ExpandableStringEnum<SyncAgentState> {
    /**
     * Static value Online for SyncAgentState.
     */
    public static final SyncAgentState ONLINE = fromString("Online");

    /**
     * Static value Offline for SyncAgentState.
     */
    public static final SyncAgentState OFFLINE = fromString("Offline");

    /**
     * Static value NeverConnected for SyncAgentState.
     */
    public static final SyncAgentState NEVER_CONNECTED = fromString("NeverConnected");

    /**
     * Creates a new instance of SyncAgentState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SyncAgentState() {
    }

    /**
     * Creates or finds a SyncAgentState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SyncAgentState.
     */
    public static SyncAgentState fromString(String name) {
        return fromString(name, SyncAgentState.class);
    }

    /**
     * Gets known SyncAgentState values.
     * 
     * @return known SyncAgentState values.
     */
    public static Collection<SyncAgentState> values() {
        return values(SyncAgentState.class);
    }
}
