// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a Vulnerability Assessment recurring scans.
 */
@Fluent
public final class VulnerabilityAssessmentRecurringScansProperties
    implements JsonSerializable<VulnerabilityAssessmentRecurringScansProperties> {
    /*
     * Recurring scans state.
     */
    private Boolean isEnabled;

    /*
     * Specifies that the schedule scan notification will be is sent to the subscription administrators.
     */
    private Boolean emailSubscriptionAdmins;

    /*
     * Specifies an array of e-mail addresses to which the scan notification is sent.
     */
    private List<String> emails;

    /**
     * Creates an instance of VulnerabilityAssessmentRecurringScansProperties class.
     */
    public VulnerabilityAssessmentRecurringScansProperties() {
    }

    /**
     * Get the isEnabled property: Recurring scans state.
     * 
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Recurring scans state.
     * 
     * @param isEnabled the isEnabled value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the emailSubscriptionAdmins property: Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     * 
     * @return the emailSubscriptionAdmins value.
     */
    public Boolean emailSubscriptionAdmins() {
        return this.emailSubscriptionAdmins;
    }

    /**
     * Set the emailSubscriptionAdmins property: Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     * 
     * @param emailSubscriptionAdmins the emailSubscriptionAdmins value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties
        withEmailSubscriptionAdmins(Boolean emailSubscriptionAdmins) {
        this.emailSubscriptionAdmins = emailSubscriptionAdmins;
        return this;
    }

    /**
     * Get the emails property: Specifies an array of e-mail addresses to which the scan notification is sent.
     * 
     * @return the emails value.
     */
    public List<String> emails() {
        return this.emails;
    }

    /**
     * Set the emails property: Specifies an array of e-mail addresses to which the scan notification is sent.
     * 
     * @param emails the emails value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withEmails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeBooleanField("emailSubscriptionAdmins", this.emailSubscriptionAdmins);
        jsonWriter.writeArrayField("emails", this.emails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VulnerabilityAssessmentRecurringScansProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VulnerabilityAssessmentRecurringScansProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VulnerabilityAssessmentRecurringScansProperties.
     */
    public static VulnerabilityAssessmentRecurringScansProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VulnerabilityAssessmentRecurringScansProperties deserializedVulnerabilityAssessmentRecurringScansProperties
                = new VulnerabilityAssessmentRecurringScansProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isEnabled".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentRecurringScansProperties.isEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("emailSubscriptionAdmins".equals(fieldName)) {
                    deserializedVulnerabilityAssessmentRecurringScansProperties.emailSubscriptionAdmins
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("emails".equals(fieldName)) {
                    List<String> emails = reader.readArray(reader1 -> reader1.getString());
                    deserializedVulnerabilityAssessmentRecurringScansProperties.emails = emails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVulnerabilityAssessmentRecurringScansProperties;
        });
    }
}
