// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Server communication link. */
@JsonFlatten
@Fluent
public class ServerCommunicationLinkInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ServerCommunicationLinkInner.class);

    /*
     * Communication link location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Communication link kind.  This property is used for Azure Portal
     * metadata.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /*
     * The state.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /*
     * The name of the partner server.
     */
    @JsonProperty(value = "properties.partnerServer")
    private String partnerServer;

    /**
     * Get the location property: Communication link location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the kind property: Communication link kind. This property is used for Azure Portal metadata.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the state property: The state.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the partnerServer property: The name of the partner server.
     *
     * @return the partnerServer value.
     */
    public String partnerServer() {
        return this.partnerServer;
    }

    /**
     * Set the partnerServer property: The name of the partner server.
     *
     * @param partnerServer the partnerServer value to set.
     * @return the ServerCommunicationLinkInner object itself.
     */
    public ServerCommunicationLinkInner withPartnerServer(String partnerServer) {
        this.partnerServer = partnerServer;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
