// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Usage Metric of a Subscription in a Location. */
@JsonFlatten
@Immutable
public class SubscriptionUsageInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SubscriptionUsageInner.class);

    /*
     * User-readable name of the metric.
     */
    @JsonProperty(value = "properties.displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * Current value of the metric.
     */
    @JsonProperty(value = "properties.currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Double currentValue;

    /*
     * Boundary value of the metric.
     */
    @JsonProperty(value = "properties.limit", access = JsonProperty.Access.WRITE_ONLY)
    private Double limit;

    /*
     * Unit of the metric.
     */
    @JsonProperty(value = "properties.unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /**
     * Get the displayName property: User-readable name of the metric.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the currentValue property: Current value of the metric.
     *
     * @return the currentValue value.
     */
    public Double currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: Boundary value of the metric.
     *
     * @return the limit value.
     */
    public Double limit() {
        return this.limit;
    }

    /**
     * Get the unit property: Unit of the metric.
     *
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
