// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionActivityStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents a database transparent data encryption Scan. */
@JsonFlatten
@Immutable
public class TransparentDataEncryptionActivityInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TransparentDataEncryptionActivityInner.class);

    /*
     * Resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * The status of the database.
     */
    @JsonProperty(value = "properties.status", access = JsonProperty.Access.WRITE_ONLY)
    private TransparentDataEncryptionActivityStatus status;

    /*
     * The percent complete of the transparent data encryption scan for a
     * database.
     */
    @JsonProperty(value = "properties.percentComplete", access = JsonProperty.Access.WRITE_ONLY)
    private Float percentComplete;

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the status property: The status of the database.
     *
     * @return the status value.
     */
    public TransparentDataEncryptionActivityStatus status() {
        return this.status;
    }

    /**
     * Get the percentComplete property: The percent complete of the transparent data encryption scan for a database.
     *
     * @return the percentComplete value.
     */
    public Float percentComplete() {
        return this.percentComplete;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
