// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.JobStepExecutionsClient;
import com.azure.resourcemanager.sql.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.sql.models.JobExecutionListResult;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in JobStepExecutionsClient. */
public final class JobStepExecutionsClientImpl implements JobStepExecutionsClient {
    private final ClientLogger logger = new ClientLogger(JobStepExecutionsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final JobStepExecutionsService service;

    /** The service client containing this operation class. */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of JobStepExecutionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    JobStepExecutionsClientImpl(SqlManagementClientImpl client) {
        this.service =
            RestProxy.create(JobStepExecutionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlManagementClientJobStepExecutions to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientJ")
    private interface JobStepExecutionsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers"
                + "/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<JobExecutionListResult>> listByJobExecution(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serverName") String serverName,
            @PathParam("jobAgentName") String jobAgentName,
            @PathParam("jobName") String jobName,
            @PathParam("jobExecutionId") UUID jobExecutionId,
            @QueryParam("createTimeMin") OffsetDateTime createTimeMin,
            @QueryParam("createTimeMax") OffsetDateTime createTimeMax,
            @QueryParam("endTimeMin") OffsetDateTime endTimeMin,
            @QueryParam("endTimeMax") OffsetDateTime endTimeMax,
            @QueryParam("isActive") Boolean isActive,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$top") Integer top,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers"
                + "/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<JobExecutionInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("serverName") String serverName,
            @PathParam("jobAgentName") String jobAgentName,
            @PathParam("jobName") String jobName,
            @PathParam("jobExecutionId") UUID jobExecutionId,
            @PathParam("stepName") String stepName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<JobExecutionListResult>> listByJobExecutionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobExecutionSinglePageAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        OffsetDateTime createTimeMin,
        OffsetDateTime createTimeMax,
        OffsetDateTime endTimeMin,
        OffsetDateTime endTimeMax,
        Boolean isActive,
        Integer skip,
        Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByJobExecution(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            serverName,
                            jobAgentName,
                            jobName,
                            jobExecutionId,
                            createTimeMin,
                            createTimeMax,
                            endTimeMin,
                            endTimeMax,
                            isActive,
                            skip,
                            top,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<JobExecutionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobExecutionSinglePageAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        OffsetDateTime createTimeMin,
        OffsetDateTime createTimeMax,
        OffsetDateTime endTimeMin,
        OffsetDateTime endTimeMax,
        Boolean isActive,
        Integer skip,
        Integer top,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByJobExecution(
                this.client.getEndpoint(),
                resourceGroupName,
                serverName,
                jobAgentName,
                jobName,
                jobExecutionId,
                createTimeMin,
                createTimeMax,
                endTimeMin,
                endTimeMax,
                isActive,
                skip,
                top,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByJobExecutionAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        OffsetDateTime createTimeMin,
        OffsetDateTime createTimeMax,
        OffsetDateTime endTimeMin,
        OffsetDateTime endTimeMax,
        Boolean isActive,
        Integer skip,
        Integer top) {
        return new PagedFlux<>(
            () ->
                listByJobExecutionSinglePageAsync(
                    resourceGroupName,
                    serverName,
                    jobAgentName,
                    jobName,
                    jobExecutionId,
                    createTimeMin,
                    createTimeMax,
                    endTimeMin,
                    endTimeMax,
                    isActive,
                    skip,
                    top),
            nextLink -> listByJobExecutionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByJobExecutionAsync(
        String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        final OffsetDateTime createTimeMin = null;
        final OffsetDateTime createTimeMax = null;
        final OffsetDateTime endTimeMin = null;
        final OffsetDateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return new PagedFlux<>(
            () ->
                listByJobExecutionSinglePageAsync(
                    resourceGroupName,
                    serverName,
                    jobAgentName,
                    jobName,
                    jobExecutionId,
                    createTimeMin,
                    createTimeMax,
                    endTimeMin,
                    endTimeMax,
                    isActive,
                    skip,
                    top),
            nextLink -> listByJobExecutionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<JobExecutionInner> listByJobExecutionAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        OffsetDateTime createTimeMin,
        OffsetDateTime createTimeMax,
        OffsetDateTime endTimeMin,
        OffsetDateTime endTimeMax,
        Boolean isActive,
        Integer skip,
        Integer top,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByJobExecutionSinglePageAsync(
                    resourceGroupName,
                    serverName,
                    jobAgentName,
                    jobName,
                    jobExecutionId,
                    createTimeMin,
                    createTimeMax,
                    endTimeMin,
                    endTimeMax,
                    isActive,
                    skip,
                    top,
                    context),
            nextLink -> listByJobExecutionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByJobExecution(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        OffsetDateTime createTimeMin,
        OffsetDateTime createTimeMax,
        OffsetDateTime endTimeMin,
        OffsetDateTime endTimeMax,
        Boolean isActive,
        Integer skip,
        Integer top,
        Context context) {
        return new PagedIterable<>(
            listByJobExecutionAsync(
                resourceGroupName,
                serverName,
                jobAgentName,
                jobName,
                jobExecutionId,
                createTimeMin,
                createTimeMax,
                endTimeMin,
                endTimeMax,
                isActive,
                skip,
                top,
                context));
    }

    /**
     * Lists the step executions of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The id of the job execution.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByJobExecution(
        String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        final OffsetDateTime createTimeMin = null;
        final OffsetDateTime createTimeMax = null;
        final OffsetDateTime endTimeMin = null;
        final OffsetDateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return new PagedIterable<>(
            listByJobExecutionAsync(
                resourceGroupName,
                serverName,
                jobAgentName,
                jobName,
                jobExecutionId,
                createTimeMin,
                createTimeMax,
                endTimeMin,
                endTimeMax,
                isActive,
                skip,
                top));
    }

    /**
     * Gets a step execution of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution.
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a step execution of a job execution.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<JobExecutionInner>> getWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        String stepName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error(new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            serverName,
                            jobAgentName,
                            jobName,
                            jobExecutionId,
                            stepName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a step execution of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution.
     * @param stepName The name of the step.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a step execution of a job execution.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobExecutionInner>> getWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        String stepName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error(new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                serverName,
                jobAgentName,
                jobName,
                jobExecutionId,
                stepName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Gets a step execution of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution.
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a step execution of a job execution.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<JobExecutionInner> getAsync(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        String stepName) {
        return getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName)
            .flatMap(
                (Response<JobExecutionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a step execution of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution.
     * @param stepName The name of the step.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a step execution of a job execution.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobExecutionInner get(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        String stepName) {
        return getAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName).block();
    }

    /**
     * Gets a step execution of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The unique id of the job execution.
     * @param stepName The name of the step.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a step execution of a job execution.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<JobExecutionInner> getWithResponse(
        String resourceGroupName,
        String serverName,
        String jobAgentName,
        String jobName,
        UUID jobExecutionId,
        String stepName,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, context)
            .block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobExecutionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByJobExecutionNext(nextLink, context))
            .<PagedResponse<JobExecutionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of job executions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobExecutionNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByJobExecutionNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
