// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for ImportOperationMode. */
public enum ImportOperationMode {
    /** Enum value Import. */
    IMPORT("Import");

    /** The actual serialized value for a ImportOperationMode instance. */
    private final String value;

    ImportOperationMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ImportOperationMode instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ImportOperationMode object, or null if unable to parse.
     */
    @JsonCreator
    public static ImportOperationMode fromString(String value) {
        ImportOperationMode[] items = ImportOperationMode.values();
        for (ImportOperationMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
