// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for StorageKeyType. */
public enum StorageKeyType {
    /** Enum value StorageAccessKey. */
    STORAGE_ACCESS_KEY("StorageAccessKey"),

    /** Enum value SharedAccessKey. */
    SHARED_ACCESS_KEY("SharedAccessKey");

    /** The actual serialized value for a StorageKeyType instance. */
    private final String value;

    StorageKeyType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StorageKeyType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed StorageKeyType object, or null if unable to parse.
     */
    @JsonCreator
    public static StorageKeyType fromString(String value) {
        StorageKeyType[] items = StorageKeyType.values();
        for (StorageKeyType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
