/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BlobAuditingPolicyState;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ExtendedServerBlobAuditingPolicyProperties
implements JsonSerializable<ExtendedServerBlobAuditingPolicyProperties> {
    private Boolean isDevopsAuditEnabled;
    private String predicateExpression;
    private Integer retentionDays;
    private List<String> auditActionsAndGroups;
    private Boolean isStorageSecondaryKeyInUse;
    private Boolean isAzureMonitorTargetEnabled;
    private Integer queueDelayMs;
    private Boolean isManagedIdentityInUse;
    private BlobAuditingPolicyState state;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private UUID storageAccountSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ExtendedServerBlobAuditingPolicyProperties.class);

    public Boolean isDevopsAuditEnabled() {
        return this.isDevopsAuditEnabled;
    }

    public ExtendedServerBlobAuditingPolicyProperties withIsDevopsAuditEnabled(Boolean isDevopsAuditEnabled) {
        this.isDevopsAuditEnabled = isDevopsAuditEnabled;
        return this;
    }

    public String predicateExpression() {
        return this.predicateExpression;
    }

    public ExtendedServerBlobAuditingPolicyProperties withPredicateExpression(String predicateExpression) {
        this.predicateExpression = predicateExpression;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public ExtendedServerBlobAuditingPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public List<String> auditActionsAndGroups() {
        return this.auditActionsAndGroups;
    }

    public ExtendedServerBlobAuditingPolicyProperties withAuditActionsAndGroups(List<String> auditActionsAndGroups) {
        this.auditActionsAndGroups = auditActionsAndGroups;
        return this;
    }

    public Boolean isStorageSecondaryKeyInUse() {
        return this.isStorageSecondaryKeyInUse;
    }

    public ExtendedServerBlobAuditingPolicyProperties withIsStorageSecondaryKeyInUse(Boolean isStorageSecondaryKeyInUse) {
        this.isStorageSecondaryKeyInUse = isStorageSecondaryKeyInUse;
        return this;
    }

    public Boolean isAzureMonitorTargetEnabled() {
        return this.isAzureMonitorTargetEnabled;
    }

    public ExtendedServerBlobAuditingPolicyProperties withIsAzureMonitorTargetEnabled(Boolean isAzureMonitorTargetEnabled) {
        this.isAzureMonitorTargetEnabled = isAzureMonitorTargetEnabled;
        return this;
    }

    public Integer queueDelayMs() {
        return this.queueDelayMs;
    }

    public ExtendedServerBlobAuditingPolicyProperties withQueueDelayMs(Integer queueDelayMs) {
        this.queueDelayMs = queueDelayMs;
        return this;
    }

    public Boolean isManagedIdentityInUse() {
        return this.isManagedIdentityInUse;
    }

    public ExtendedServerBlobAuditingPolicyProperties withIsManagedIdentityInUse(Boolean isManagedIdentityInUse) {
        this.isManagedIdentityInUse = isManagedIdentityInUse;
        return this;
    }

    public BlobAuditingPolicyState state() {
        return this.state;
    }

    public ExtendedServerBlobAuditingPolicyProperties withState(BlobAuditingPolicyState state) {
        this.state = state;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public ExtendedServerBlobAuditingPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public ExtendedServerBlobAuditingPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public UUID storageAccountSubscriptionId() {
        return this.storageAccountSubscriptionId;
    }

    public ExtendedServerBlobAuditingPolicyProperties withStorageAccountSubscriptionId(UUID storageAccountSubscriptionId) {
        this.storageAccountSubscriptionId = storageAccountSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model ExtendedServerBlobAuditingPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("isDevopsAuditEnabled", this.isDevopsAuditEnabled);
        jsonWriter.writeStringField("predicateExpression", this.predicateExpression);
        jsonWriter.writeNumberField("retentionDays", (Number)this.retentionDays);
        jsonWriter.writeArrayField("auditActionsAndGroups", this.auditActionsAndGroups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isStorageSecondaryKeyInUse", this.isStorageSecondaryKeyInUse);
        jsonWriter.writeBooleanField("isAzureMonitorTargetEnabled", this.isAzureMonitorTargetEnabled);
        jsonWriter.writeNumberField("queueDelayMs", (Number)this.queueDelayMs);
        jsonWriter.writeBooleanField("isManagedIdentityInUse", this.isManagedIdentityInUse);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeStringField("storageAccountSubscriptionId", Objects.toString(this.storageAccountSubscriptionId, null));
        return jsonWriter.writeEndObject();
    }

    public static ExtendedServerBlobAuditingPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExtendedServerBlobAuditingPolicyProperties)jsonReader.readObject(reader -> {
            ExtendedServerBlobAuditingPolicyProperties deserializedExtendedServerBlobAuditingPolicyProperties = new ExtendedServerBlobAuditingPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.state = BlobAuditingPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("isDevopsAuditEnabled".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.isDevopsAuditEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("predicateExpression".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.predicateExpression = reader.getString();
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.retentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("auditActionsAndGroups".equals(fieldName)) {
                    List auditActionsAndGroups;
                    deserializedExtendedServerBlobAuditingPolicyProperties.auditActionsAndGroups = auditActionsAndGroups = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isStorageSecondaryKeyInUse".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.isStorageSecondaryKeyInUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isAzureMonitorTargetEnabled".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.isAzureMonitorTargetEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queueDelayMs".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.queueDelayMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isManagedIdentityInUse".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.isManagedIdentityInUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("storageAccountSubscriptionId".equals(fieldName)) {
                    deserializedExtendedServerBlobAuditingPolicyProperties.storageAccountSubscriptionId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtendedServerBlobAuditingPolicyProperties;
        });
    }
}

