/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ServerOperationProperties;
import com.azure.resourcemanager.sql.models.ManagementOperationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ServerOperationInner
extends ProxyResource {
    private ServerOperationProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ServerOperationProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String operation() {
        return this.innerProperties() == null ? null : this.innerProperties().operation();
    }

    public String operationFriendlyName() {
        return this.innerProperties() == null ? null : this.innerProperties().operationFriendlyName();
    }

    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public ManagementOperationState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Integer errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    public String errorDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().errorDescription();
    }

    public Integer errorSeverity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorSeverity();
    }

    public Boolean isUserError() {
        return this.innerProperties() == null ? null : this.innerProperties().isUserError();
    }

    public OffsetDateTime estimatedCompletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().estimatedCompletionTime();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public Boolean isCancellable() {
        return this.innerProperties() == null ? null : this.innerProperties().isCancellable();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerOperationInner)((Object)jsonReader.readObject(reader -> {
            ServerOperationInner deserializedServerOperationInner = new ServerOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerOperationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerOperationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerOperationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerOperationInner.innerProperties = ServerOperationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerOperationInner;
        }));
    }
}

