// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AdvisorStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatusInheritedFrom;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Properties for a Database, Server or Elastic Pool Advisor.
 */
@Fluent
public final class AdvisorProperties implements JsonSerializable<AdvisorProperties> {
    /*
     * Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview',
     * 'LimitedPublicPreview' and 'PrivatePreview'.
     */
    private AdvisorStatus advisorStatus;

    /*
     * Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible
     * values are 'Enabled' and 'Disabled'
     */
    private AutoExecuteStatus autoExecuteStatus;

    /*
     * Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set on
     * (and inherited from) different levels in the resource hierarchy. Possible values are 'Subscription', 'Server',
     * 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
     */
    private AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom;

    /*
     * Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible
     * values include, but are not limited to, 'Ok' (Recommendations available),LowActivity (not enough workload to
     * analyze), 'DbSeemsTuned' (Database is doing well), etc.
     */
    private String recommendationsStatus;

    /*
     * Gets the time when the current resource was analyzed for recommendations by this advisor.
     */
    private OffsetDateTime lastChecked;

    /*
     * Gets the recommended actions for this advisor.
     */
    private List<RecommendedActionInner> recommendedActions;

    /**
     * Creates an instance of AdvisorProperties class.
     */
    public AdvisorProperties() {
    }

    /**
     * Get the advisorStatus property: Gets the status of availability of this advisor to customers. Possible values are
     * 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'.
     * 
     * @return the advisorStatus value.
     */
    public AdvisorStatus advisorStatus() {
        return this.advisorStatus;
    }

    /**
     * Get the autoExecuteStatus property: Gets the auto-execute status (whether to let the system execute the
     * recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'.
     * 
     * @return the autoExecuteStatus value.
     */
    public AutoExecuteStatus autoExecuteStatus() {
        return this.autoExecuteStatus;
    }

    /**
     * Set the autoExecuteStatus property: Gets the auto-execute status (whether to let the system execute the
     * recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'.
     * 
     * @param autoExecuteStatus the autoExecuteStatus value to set.
     * @return the AdvisorProperties object itself.
     */
    public AdvisorProperties withAutoExecuteStatus(AutoExecuteStatus autoExecuteStatus) {
        this.autoExecuteStatus = autoExecuteStatus;
        return this;
    }

    /**
     * Get the autoExecuteStatusInheritedFrom property: Gets the resource from which current value of auto-execute
     * status is inherited. Auto-execute status can be set on (and inherited from) different levels in the resource
     * hierarchy. Possible values are 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is
     * not explicitly set on any level).
     * 
     * @return the autoExecuteStatusInheritedFrom value.
     */
    public AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom() {
        return this.autoExecuteStatusInheritedFrom;
    }

    /**
     * Get the recommendationsStatus property: Gets that status of recommendations for this advisor and reason for not
     * having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations
     * available),LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
     * 
     * @return the recommendationsStatus value.
     */
    public String recommendationsStatus() {
        return this.recommendationsStatus;
    }

    /**
     * Get the lastChecked property: Gets the time when the current resource was analyzed for recommendations by this
     * advisor.
     * 
     * @return the lastChecked value.
     */
    public OffsetDateTime lastChecked() {
        return this.lastChecked;
    }

    /**
     * Get the recommendedActions property: Gets the recommended actions for this advisor.
     * 
     * @return the recommendedActions value.
     */
    public List<RecommendedActionInner> recommendedActions() {
        return this.recommendedActions;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoExecuteStatus() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property autoExecuteStatus in model AdvisorProperties"));
        }
        if (recommendedActions() != null) {
            recommendedActions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AdvisorProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoExecuteStatus",
            this.autoExecuteStatus == null ? null : this.autoExecuteStatus.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdvisorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdvisorProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AdvisorProperties.
     */
    public static AdvisorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdvisorProperties deserializedAdvisorProperties = new AdvisorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("autoExecuteStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.autoExecuteStatus = AutoExecuteStatus.fromString(reader.getString());
                } else if ("advisorStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.advisorStatus = AdvisorStatus.fromString(reader.getString());
                } else if ("autoExecuteStatusInheritedFrom".equals(fieldName)) {
                    deserializedAdvisorProperties.autoExecuteStatusInheritedFrom
                        = AutoExecuteStatusInheritedFrom.fromString(reader.getString());
                } else if ("recommendationsStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.recommendationsStatus = reader.getString();
                } else if ("lastChecked".equals(fieldName)) {
                    deserializedAdvisorProperties.lastChecked = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("recommendedActions".equals(fieldName)) {
                    List<RecommendedActionInner> recommendedActions
                        = reader.readArray(reader1 -> RecommendedActionInner.fromJson(reader1));
                    deserializedAdvisorProperties.recommendedActions = recommendedActions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdvisorProperties;
        });
    }
}
