// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * A elastic pool operation.
 */
@Immutable
public final class ElasticPoolOperationInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ElasticPoolOperationProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ElasticPoolOperationInner class.
     */
    public ElasticPoolOperationInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ElasticPoolOperationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the elasticPoolName property: The name of the elastic pool the operation is being performed on.
     * 
     * @return the elasticPoolName value.
     */
    public String elasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolName();
    }

    /**
     * Get the operation property: The name of operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.innerProperties() == null ? null : this.innerProperties().operation();
    }

    /**
     * Get the operationFriendlyName property: The friendly name of operation.
     * 
     * @return the operationFriendlyName value.
     */
    public String operationFriendlyName() {
        return this.innerProperties() == null ? null : this.innerProperties().operationFriendlyName();
    }

    /**
     * Get the percentComplete property: The percentage of the operation completed.
     * 
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    /**
     * Get the serverName property: The name of the server.
     * 
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the startTime property: The operation start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the state property: The operation state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the errorCode property: The operation error code.
     * 
     * @return the errorCode value.
     */
    public Integer errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    /**
     * Get the errorDescription property: The operation error description.
     * 
     * @return the errorDescription value.
     */
    public String errorDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().errorDescription();
    }

    /**
     * Get the errorSeverity property: The operation error severity.
     * 
     * @return the errorSeverity value.
     */
    public Integer errorSeverity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorSeverity();
    }

    /**
     * Get the isUserError property: Whether or not the error is a user error.
     * 
     * @return the isUserError value.
     */
    public Boolean isUserError() {
        return this.innerProperties() == null ? null : this.innerProperties().isUserError();
    }

    /**
     * Get the estimatedCompletionTime property: The estimated completion time of the operation.
     * 
     * @return the estimatedCompletionTime value.
     */
    public OffsetDateTime estimatedCompletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().estimatedCompletionTime();
    }

    /**
     * Get the description property: The operation description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the isCancellable property: Whether the operation can be cancelled.
     * 
     * @return the isCancellable value.
     */
    public Boolean isCancellable() {
        return this.innerProperties() == null ? null : this.innerProperties().isCancellable();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElasticPoolOperationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElasticPoolOperationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ElasticPoolOperationInner.
     */
    public static ElasticPoolOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolOperationInner deserializedElasticPoolOperationInner = new ElasticPoolOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedElasticPoolOperationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedElasticPoolOperationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedElasticPoolOperationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedElasticPoolOperationInner.innerProperties
                        = ElasticPoolOperationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedElasticPoolOperationInner;
        });
    }
}
