// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ProxyResourceWithWritableName;
import java.io.IOException;

/**
 * An IPv6 server firewall rule.
 */
@Fluent
public final class IPv6FirewallRuleInner extends ProxyResourceWithWritableName {
    /*
     * Resource properties.
     */
    private IPv6ServerFirewallRuleProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of IPv6FirewallRuleInner class.
     */
    public IPv6FirewallRuleInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private IPv6ServerFirewallRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IPv6FirewallRuleInner withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * Get the startIPv6Address property: The start IP address of the firewall rule. Must be IPv6 format.
     * 
     * @return the startIPv6Address value.
     */
    public String startIPv6Address() {
        return this.innerProperties() == null ? null : this.innerProperties().startIPv6Address();
    }

    /**
     * Set the startIPv6Address property: The start IP address of the firewall rule. Must be IPv6 format.
     * 
     * @param startIPv6Address the startIPv6Address value to set.
     * @return the IPv6FirewallRuleInner object itself.
     */
    public IPv6FirewallRuleInner withStartIPv6Address(String startIPv6Address) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IPv6ServerFirewallRuleProperties();
        }
        this.innerProperties().withStartIPv6Address(startIPv6Address);
        return this;
    }

    /**
     * Get the endIPv6Address property: The end IP address of the firewall rule. Must be IPv6 format. Must be greater
     * than or equal to startIpAddress.
     * 
     * @return the endIPv6Address value.
     */
    public String endIPv6Address() {
        return this.innerProperties() == null ? null : this.innerProperties().endIPv6Address();
    }

    /**
     * Set the endIPv6Address property: The end IP address of the firewall rule. Must be IPv6 format. Must be greater
     * than or equal to startIpAddress.
     * 
     * @param endIPv6Address the endIPv6Address value to set.
     * @return the IPv6FirewallRuleInner object itself.
     */
    public IPv6FirewallRuleInner withEndIPv6Address(String endIPv6Address) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IPv6ServerFirewallRuleProperties();
        }
        this.innerProperties().withEndIPv6Address(endIPv6Address);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IPv6FirewallRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IPv6FirewallRuleInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IPv6FirewallRuleInner.
     */
    public static IPv6FirewallRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IPv6FirewallRuleInner deserializedIPv6FirewallRuleInner = new IPv6FirewallRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIPv6FirewallRuleInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIPv6FirewallRuleInner.type = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedIPv6FirewallRuleInner.withName(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedIPv6FirewallRuleInner.innerProperties
                        = IPv6ServerFirewallRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIPv6FirewallRuleInner;
        });
    }
}
