// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobSchedule;
import java.io.IOException;

/**
 * A job.
 */
@Fluent
public final class JobInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private JobProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of JobInner class.
     */
    public JobInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: User-defined description of the job.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: User-defined description of the job.
     * 
     * @param description the description value to set.
     * @return the JobInner object itself.
     */
    public JobInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the version property: The job version number.
     * 
     * @return the version value.
     */
    public Integer version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Get the schedule property: Schedule properties of the job.
     * 
     * @return the schedule value.
     */
    public JobSchedule schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    /**
     * Set the schedule property: Schedule properties of the job.
     * 
     * @param schedule the schedule value to set.
     * @return the JobInner object itself.
     */
    public JobInner withSchedule(JobSchedule schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the JobInner.
     */
    public static JobInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobInner deserializedJobInner = new JobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedJobInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedJobInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedJobInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedJobInner.innerProperties = JobProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobInner;
        });
    }
}
