// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance pool capability.
 */
@Fluent
public final class InstancePoolEditionCapability implements JsonSerializable<InstancePoolEditionCapability> {
    /*
     * The instance pool version name.
     */
    private String name;

    /*
     * The supported families.
     */
    private List<InstancePoolFamilyCapability> supportedFamilies;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of InstancePoolEditionCapability class.
     */
    public InstancePoolEditionCapability() {
    }

    /**
     * Get the name property: The instance pool version name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedFamilies property: The supported families.
     * 
     * @return the supportedFamilies value.
     */
    public List<InstancePoolFamilyCapability> supportedFamilies() {
        return this.supportedFamilies;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the InstancePoolEditionCapability object itself.
     */
    public InstancePoolEditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedFamilies() != null) {
            supportedFamilies().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstancePoolEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstancePoolEditionCapability if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InstancePoolEditionCapability.
     */
    public static InstancePoolEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstancePoolEditionCapability deserializedInstancePoolEditionCapability
                = new InstancePoolEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedInstancePoolEditionCapability.name = reader.getString();
                } else if ("supportedFamilies".equals(fieldName)) {
                    List<InstancePoolFamilyCapability> supportedFamilies
                        = reader.readArray(reader1 -> InstancePoolFamilyCapability.fromJson(reader1));
                    deserializedInstancePoolEditionCapability.supportedFamilies = supportedFamilies;
                } else if ("status".equals(fieldName)) {
                    deserializedInstancePoolEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedInstancePoolEditionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstancePoolEditionCapability;
        });
    }
}
