// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The managed instance virtual cores capability.
 */
@Fluent
public final class InstancePoolVcoresCapability implements JsonSerializable<InstancePoolVcoresCapability> {
    /*
     * The virtual cores identifier.
     */
    private String name;

    /*
     * The virtual cores value.
     */
    private Integer value;

    /*
     * Storage limit.
     */
    private MaxSizeCapability storageLimit;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of InstancePoolVcoresCapability class.
     */
    public InstancePoolVcoresCapability() {
    }

    /**
     * Get the name property: The virtual cores identifier.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: The virtual cores value.
     * 
     * @return the value value.
     */
    public Integer value() {
        return this.value;
    }

    /**
     * Get the storageLimit property: Storage limit.
     * 
     * @return the storageLimit value.
     */
    public MaxSizeCapability storageLimit() {
        return this.storageLimit;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the InstancePoolVcoresCapability object itself.
     */
    public InstancePoolVcoresCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageLimit() != null) {
            storageLimit().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstancePoolVcoresCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstancePoolVcoresCapability if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InstancePoolVcoresCapability.
     */
    public static InstancePoolVcoresCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstancePoolVcoresCapability deserializedInstancePoolVcoresCapability = new InstancePoolVcoresCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedInstancePoolVcoresCapability.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedInstancePoolVcoresCapability.value = reader.getNullable(JsonReader::getInt);
                } else if ("storageLimit".equals(fieldName)) {
                    deserializedInstancePoolVcoresCapability.storageLimit = MaxSizeCapability.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedInstancePoolVcoresCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedInstancePoolVcoresCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstancePoolVcoresCapability;
        });
    }
}
