// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The steps of a managed instance operation.
 */
@Immutable
public final class ManagedInstanceOperationSteps implements JsonSerializable<ManagedInstanceOperationSteps> {
    /*
     * The total number of operation steps.
     */
    private String totalSteps;

    /*
     * The number of current operation steps.
     */
    private Integer currentStep;

    /*
     * The operation steps list.
     */
    private List<UpsertManagedServerOperationStepWithEstimatesAndDuration> stepsList;

    /**
     * Creates an instance of ManagedInstanceOperationSteps class.
     */
    public ManagedInstanceOperationSteps() {
    }

    /**
     * Get the totalSteps property: The total number of operation steps.
     * 
     * @return the totalSteps value.
     */
    public String totalSteps() {
        return this.totalSteps;
    }

    /**
     * Get the currentStep property: The number of current operation steps.
     * 
     * @return the currentStep value.
     */
    public Integer currentStep() {
        return this.currentStep;
    }

    /**
     * Get the stepsList property: The operation steps list.
     * 
     * @return the stepsList value.
     */
    public List<UpsertManagedServerOperationStepWithEstimatesAndDuration> stepsList() {
        return this.stepsList;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (stepsList() != null) {
            stepsList().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceOperationSteps from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceOperationSteps if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceOperationSteps.
     */
    public static ManagedInstanceOperationSteps fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceOperationSteps deserializedManagedInstanceOperationSteps
                = new ManagedInstanceOperationSteps();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("totalSteps".equals(fieldName)) {
                    deserializedManagedInstanceOperationSteps.totalSteps = reader.getString();
                } else if ("currentStep".equals(fieldName)) {
                    deserializedManagedInstanceOperationSteps.currentStep = reader.getNullable(JsonReader::getInt);
                } else if ("stepsList".equals(fieldName)) {
                    List<UpsertManagedServerOperationStepWithEstimatesAndDuration> stepsList = reader.readArray(
                        reader1 -> UpsertManagedServerOperationStepWithEstimatesAndDuration.fromJson(reader1));
                    deserializedManagedInstanceOperationSteps.stepsList = stepsList;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceOperationSteps;
        });
    }
}
