// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The UpsertManagedServerOperationParameters model.
 */
@Fluent
public final class UpsertManagedServerOperationParameters
    implements JsonSerializable<UpsertManagedServerOperationParameters> {
    /*
     * The family property.
     */
    private String family;

    /*
     * The tier property.
     */
    private String tier;

    /*
     * The vCores property.
     */
    private Integer vCores;

    /*
     * The storageSizeInGB property.
     */
    private Integer storageSizeInGB;

    /**
     * Creates an instance of UpsertManagedServerOperationParameters class.
     */
    public UpsertManagedServerOperationParameters() {
    }

    /**
     * Get the family property: The family property.
     * 
     * @return the family value.
     */
    public String family() {
        return this.family;
    }

    /**
     * Set the family property: The family property.
     * 
     * @param family the family value to set.
     * @return the UpsertManagedServerOperationParameters object itself.
     */
    public UpsertManagedServerOperationParameters withFamily(String family) {
        this.family = family;
        return this;
    }

    /**
     * Get the tier property: The tier property.
     * 
     * @return the tier value.
     */
    public String tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The tier property.
     * 
     * @param tier the tier value to set.
     * @return the UpsertManagedServerOperationParameters object itself.
     */
    public UpsertManagedServerOperationParameters withTier(String tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the vCores property: The vCores property.
     * 
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.vCores;
    }

    /**
     * Set the vCores property: The vCores property.
     * 
     * @param vCores the vCores value to set.
     * @return the UpsertManagedServerOperationParameters object itself.
     */
    public UpsertManagedServerOperationParameters withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    /**
     * Get the storageSizeInGB property: The storageSizeInGB property.
     * 
     * @return the storageSizeInGB value.
     */
    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    /**
     * Set the storageSizeInGB property: The storageSizeInGB property.
     * 
     * @param storageSizeInGB the storageSizeInGB value to set.
     * @return the UpsertManagedServerOperationParameters object itself.
     */
    public UpsertManagedServerOperationParameters withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeNumberField("vCores", this.vCores);
        jsonWriter.writeNumberField("storageSizeInGB", this.storageSizeInGB);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpsertManagedServerOperationParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpsertManagedServerOperationParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpsertManagedServerOperationParameters.
     */
    public static UpsertManagedServerOperationParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpsertManagedServerOperationParameters deserializedUpsertManagedServerOperationParameters
                = new UpsertManagedServerOperationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("family".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationParameters.family = reader.getString();
                } else if ("tier".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationParameters.tier = reader.getString();
                } else if ("vCores".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationParameters.vCores = reader.getNullable(JsonReader::getInt);
                } else if ("storageSizeInGB".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationParameters.storageSizeInGB
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpsertManagedServerOperationParameters;
        });
    }
}
