// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AdvancedThreatProtectionState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of an Advanced Threat Protection state.
 */
@Fluent
public final class AdvancedThreatProtectionProperties implements JsonSerializable<AdvancedThreatProtectionProperties> {
    /*
     * Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled or a state has not been
     * applied yet on the specific database or server.
     */
    private AdvancedThreatProtectionState state;

    /*
     * Specifies the UTC creation time of the policy.
     */
    private OffsetDateTime creationTime;

    /**
     * Creates an instance of AdvancedThreatProtectionProperties class.
     */
    public AdvancedThreatProtectionProperties() {
    }

    /**
     * Get the state property: Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled
     * or a state has not been applied yet on the specific database or server.
     * 
     * @return the state value.
     */
    public AdvancedThreatProtectionState state() {
        return this.state;
    }

    /**
     * Set the state property: Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled
     * or a state has not been applied yet on the specific database or server.
     * 
     * @param state the state value to set.
     * @return the AdvancedThreatProtectionProperties object itself.
     */
    public AdvancedThreatProtectionProperties withState(AdvancedThreatProtectionState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the creationTime property: Specifies the UTC creation time of the policy.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (state() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property state in model AdvancedThreatProtectionProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AdvancedThreatProtectionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdvancedThreatProtectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdvancedThreatProtectionProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AdvancedThreatProtectionProperties.
     */
    public static AdvancedThreatProtectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdvancedThreatProtectionProperties deserializedAdvancedThreatProtectionProperties
                = new AdvancedThreatProtectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionProperties.state
                        = AdvancedThreatProtectionState.fromString(reader.getString());
                } else if ("creationTime".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdvancedThreatProtectionProperties;
        });
    }
}
