// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of an elastic pool.
 */
@Fluent
public final class ElasticPoolProperties implements JsonSerializable<ElasticPoolProperties> {
    /*
     * The state of the elastic pool.
     */
    private ElasticPoolState state;

    /*
     * The creation date of the elastic pool (ISO8601 format).
     */
    private OffsetDateTime creationDate;

    /*
     * The storage limit for the database elastic pool in bytes.
     */
    private Long maxSizeBytes;

    /*
     * Minimal capacity that serverless pool will not shrink below, if not paused
     */
    private Double minCapacity;

    /*
     * The per database settings for the elastic pool.
     */
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;

    /*
     * Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread
     * across multiple availability zones.
     */
    private Boolean zoneRedundant;

    /*
     * The license type to apply for this elastic pool.
     */
    private ElasticPoolLicenseType licenseType;

    /*
     * Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the
     * maintenance updates will will occur.
     */
    private String maintenanceConfigurationId;

    /*
     * The number of secondary replicas associated with the elastic pool that are used to provide high availability.
     * Applicable only to Hyperscale elastic pools.
     */
    private Integer highAvailabilityReplicaCount;

    /**
     * Creates an instance of ElasticPoolProperties class.
     */
    public ElasticPoolProperties() {
    }

    /**
     * Get the state property: The state of the elastic pool.
     * 
     * @return the state value.
     */
    public ElasticPoolState state() {
        return this.state;
    }

    /**
     * Get the creationDate property: The creation date of the elastic pool (ISO8601 format).
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the maxSizeBytes property: The storage limit for the database elastic pool in bytes.
     * 
     * @return the maxSizeBytes value.
     */
    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    /**
     * Set the maxSizeBytes property: The storage limit for the database elastic pool in bytes.
     * 
     * @param maxSizeBytes the maxSizeBytes value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    /**
     * Get the minCapacity property: Minimal capacity that serverless pool will not shrink below, if not paused.
     * 
     * @return the minCapacity value.
     */
    public Double minCapacity() {
        return this.minCapacity;
    }

    /**
     * Set the minCapacity property: Minimal capacity that serverless pool will not shrink below, if not paused.
     * 
     * @param minCapacity the minCapacity value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    /**
     * Get the perDatabaseSettings property: The per database settings for the elastic pool.
     * 
     * @return the perDatabaseSettings value.
     */
    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    /**
     * Set the perDatabaseSettings property: The per database settings for the elastic pool.
     * 
     * @param perDatabaseSettings the perDatabaseSettings value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not this elastic pool is zone redundant, which means the replicas of
     * this elastic pool will be spread across multiple availability zones.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Set the zoneRedundant property: Whether or not this elastic pool is zone redundant, which means the replicas of
     * this elastic pool will be spread across multiple availability zones.
     * 
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    /**
     * Get the licenseType property: The license type to apply for this elastic pool.
     * 
     * @return the licenseType value.
     */
    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType property: The license type to apply for this elastic pool.
     * 
     * @param licenseType the licenseType value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    /**
     * Get the maintenanceConfigurationId property: Maintenance configuration id assigned to the elastic pool. This
     * configuration defines the period when the maintenance updates will will occur.
     * 
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    /**
     * Set the maintenanceConfigurationId property: Maintenance configuration id assigned to the elastic pool. This
     * configuration defines the period when the maintenance updates will will occur.
     * 
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    /**
     * Get the highAvailabilityReplicaCount property: The number of secondary replicas associated with the elastic pool
     * that are used to provide high availability. Applicable only to Hyperscale elastic pools.
     * 
     * @return the highAvailabilityReplicaCount value.
     */
    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    /**
     * Set the highAvailabilityReplicaCount property: The number of secondary replicas associated with the elastic pool
     * that are used to provide high availability. Applicable only to Hyperscale elastic pools.
     * 
     * @param highAvailabilityReplicaCount the highAvailabilityReplicaCount value to set.
     * @return the ElasticPoolProperties object itself.
     */
    public ElasticPoolProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (perDatabaseSettings() != null) {
            perDatabaseSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxSizeBytes", this.maxSizeBytes);
        jsonWriter.writeNumberField("minCapacity", this.minCapacity);
        jsonWriter.writeJsonField("perDatabaseSettings", this.perDatabaseSettings);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeNumberField("highAvailabilityReplicaCount", this.highAvailabilityReplicaCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElasticPoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElasticPoolProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ElasticPoolProperties.
     */
    public static ElasticPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolProperties deserializedElasticPoolProperties = new ElasticPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedElasticPoolProperties.state = ElasticPoolState.fromString(reader.getString());
                } else if ("creationDate".equals(fieldName)) {
                    deserializedElasticPoolProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("maxSizeBytes".equals(fieldName)) {
                    deserializedElasticPoolProperties.maxSizeBytes = reader.getNullable(JsonReader::getLong);
                } else if ("minCapacity".equals(fieldName)) {
                    deserializedElasticPoolProperties.minCapacity = reader.getNullable(JsonReader::getDouble);
                } else if ("perDatabaseSettings".equals(fieldName)) {
                    deserializedElasticPoolProperties.perDatabaseSettings
                        = ElasticPoolPerDatabaseSettings.fromJson(reader);
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("licenseType".equals(fieldName)) {
                    deserializedElasticPoolProperties.licenseType
                        = ElasticPoolLicenseType.fromString(reader.getString());
                } else if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedElasticPoolProperties.maintenanceConfigurationId = reader.getString();
                } else if ("highAvailabilityReplicaCount".equals(fieldName)) {
                    deserializedElasticPoolProperties.highAvailabilityReplicaCount
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedElasticPoolProperties;
        });
    }
}
